package ikucun

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type msg struct {
}

var Msg = msg{}

type MsgRes struct {
}

/**
商品变更消息通知
*/
func (s *msg) GoodsChange(ctx context.Context) (res *MsgRes, err error) {
	method := "mengxiang.supply.goods.change.notify"
	result, err := post(ctx, method, g.Map{})
	_ = gjson.New(result).Scan(&res)
	return
}

/**
规则内商品增量通知
*/
func (s *msg) RuleGoodsChange(ctx context.Context) (res *MsgRes, err error) {
	method := "mengxiang.supply.rule.goods.change"
	result, err := post(ctx, method, g.Map{})
	_ = gjson.New(result).Scan(&res)
	return
}

/**
自助选品推送通知
*/
func (s *msg) GoodsPush(ctx context.Context) (res *MsgRes, err error) {
	method := "mengxiang.supply.self.goods.push"
	result, err := post(ctx, method, g.Map{})
	_ = gjson.New(result).Scan(&res)
	return
}

/**
发货通知、修改通知
*/
func (s *msg) OrderDelivery(ctx context.Context) (res *MsgRes, err error) {
	method := "mengxiang.supply.order.delivery.notify"
	result, err := post(ctx, method, g.Map{})
	_ = gjson.New(result).Scan(&res)
	return
}

type MsgPickUpReq struct {
	PickUpNo     string `json:"pickUpNo"`
	ThirdUserId  string `json:"thirdUserId"`
	PickUpStatus int    `json:"pickUpStatus"`
	MsgStatus    int    `json:"msgStatus"`
}

type MsgPickUpRes struct {
}

/**
上门取件消息通知
*/
func (s *msg) PickUp(ctx context.Context, req *MsgPickUpReq) (res *MsgPickUpRes, err error) {
	method := "mengxiang.aftersale.notfiy.pick.up.changes"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type MsgAfterChangeReq struct {
	GenerationTime   string `json:"generationTime"`
	AfterSalesNo     string `json:"afterSalesNo"`
	NotificationType int    `json:"notificationType"`
	OrderStatus      int    `json:"orderStatus"`
}

type MsgAfterChangeRes struct {
}

/**
售后状态变更推送
*/
func (s *msg) AftersaleChange(ctx context.Context, req *MsgAfterChangeReq) (res *MsgAfterChangeRes, err error) {
	method := "mengxiang.aftersale.notify.order.changes"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

/**
订单状态通知
*/
func (s *msg) OrderNotify(ctx context.Context) (res *MsgAfterChangeRes, err error) {
	method := "mengxiang.supply.order.event.notify"
	result, err := post(ctx, method, g.Map{})
	_ = gjson.New(result).Scan(&res)
	return
}
