package hdh

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/frame/g"
)

//分类列表
type CategoryListRes struct {
	Code string `json:"code"`
	Data []struct {
		ID              int    `json:"id"`      //类目id
		LogoURL         string `json:"logoUrl"` //类目logo图片地址
		Name            string `json:"name"`    //类目名称
		SubCategoryList []struct {
			ID              int    `json:"id"`      //类目id
			LogoURL         string `json:"logoUrl"` //类目logo图片地址
			Name            string `json:"name"`    //类目名称
			SubCategoryList []struct {
				ID      int    `json:"id"`      //
				LogoURL string `json:"logoUrl"` //
				Name    string `json:"name"`    //
			} `json:"subCategoryList"` //
		} `json:"subCategoryList"` //
	} `json:"data"`
	Message string `json:"message"`
	Success int    `json:"success"`
}

//获取分类列表
func GetCategoryList(ctx context.Context) (res *CategoryListRes, err error) {
	params := g.Map{}
	result, err := post(ctx, "/cate/get_category_list.do", params)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}
