package yunzmall

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type OrderDetailRes struct {
	CommonRes
	Data struct {
		Read struct {
			Id                   int    `json:"id"`
			CreatedAt            int    `json:"created_at"`
			UpdatedAt            int    `json:"updated_at"`
			OrderSn              int64  `json:"order_sn"`
			Status               int    `json:"status"` //0待支付 1待发货 2待收货 3已完成，-1已关闭 5退换货 6已退款
			StatusName           string `json:"status_name"`
			Title                string `json:"title"`
			Freight              int    `json:"freight"`
			Amount               int    `json:"amount"`
			ItemAmount           int    `json:"item_amount"`
			TechnicalServicesFee int    `json:"technical_services_fee"`
			Remark               string `json:"remark"`
			Note                 string `json:"note"`
			GoodsCount           int    `json:"goods_count"`
			UserId               int    `json:"user_id"`
			ShippingAddressId    int    `json:"shipping_address_id"`
			ShippingMethod       string `json:"shipping_method"`
			ShippingMethodId     int    `json:"shipping_method_id"`
			CommentStatus        int    `json:"comment_status"`
			OrderItems           []struct {
				Id             int    `json:"id"`
				OrderId        int    `json:"order_id"`
				Title          string `json:"title"`
				SkuTitle       string `json:"sku_title"`
				Unit           string `json:"unit"`
				Qty            int    `json:"qty"`
				Amount         int    `json:"amount"`
				Price          int    `json:"price"`
				ImageUrl       string `json:"image_url"`
				ProductId      int    `json:"product_id"`
				SupplyAmount   int    `json:"supply_amount"`
				SkuId          int    `json:"sku_id"`
				OrderExpressId int    `json:"order_express_id"`
				CommentStatus  int    `json:"comment_status"`
				Options        []struct {
					SpecName     string `json:"spec_name"`
					SpecItemName string `json:"spec_item_name"`
				} `json:"options"`
			} `json:"order_items"`
			OrderExpress []struct {
				Id           int    `json:"id"`
				ThirdOrderSn string `json:"third_order_sn"`
				ExpressNo    string `json:"express_no"`
				CompanyCode  string `json:"company_code"`
				CompanyName  string `json:"company_name"`
				CreatedAt    int    `json:"created_at"`
				OrderItems   []struct {
					Id         int    `json:"id"`
					ImageUrl   string `json:"image_url"`
					ProductId  int    `json:"product_id"`
					Title      string `json:"title"`
					SkuTitle   string `json:"sku_title"`
					SkuId      int    `json:"sku_id"`
					Qty        int    `json:"qty"`
					SendNum    int    `json:"send_num"`
					SendStatus int    `json:"send_status"`
					SkuSn      string `json:"sku_sn"`
				} `json:"order_items"`
				ItemExpress interface{} `json:"item_express"`
				IsEmpty     int         `json:"is_empty"`
			} `json:"order_express"`
			ShippingAddress struct {
				Id         int    `json:"id"`
				Realname   string `json:"realname"`
				Mobile     string `json:"mobile"`
				CountryId  int    `json:"country_id"`
				ProvinceId int    `json:"province_id"`
				CityId     int    `json:"city_id"`
				CountyId   int    `json:"county_id"`
				TownId     int    `json:"town_id"`
				Province   string `json:"province"`
				City       string `json:"city"`
				County     string `json:"county"`
				Town       string `json:"town"`
				Detail     string `json:"detail"`
				Lng        string `json:"lng"`
				Lat        string `json:"lat"`
			} `json:"shipping_address"`
			User struct {
				Id         int    `json:"id"`
				CreatedAt  int    `json:"created_at"`
				UpdatedAt  int    `json:"updated_at"`
				Mobile     string `json:"mobile"`
				Avatar     string `json:"avatar"`
				Username   string `json:"username"`
				Nickname   string `json:"nickname"`
				Status     int    `json:"status"`
				Uuid       string `json:"uuid"`
				LevelId    int    `json:"level_id"`
				ParentId   int    `json:"parent_id"`
				QrCode     string `json:"qr_code"`
				InviteCode string `json:"invite_code"`
				WxUsername string `json:"wx_username"`
				UserLevel  struct {
					Id        int         `json:"id"`
					CreatedAt interface{} `json:"created_at"`
					UpdatedAt interface{} `json:"updated_at"`
					Discount  int         `json:"discount"`
					Name      string      `json:"name"`
				} `json:"user_level"`
			} `json:"user"`
			AmountDetail struct {
				Title       string `json:"title"`
				Amount      int    `json:"amount"`
				Qty         int    `json:"qty"`
				Desc        string `json:"desc"`
				AmountItems []struct {
					Title       string      `json:"title"`
					Amount      int         `json:"amount"`
					Qty         int         `json:"qty"`
					Desc        string      `json:"desc"`
					AmountItems interface{} `json:"amount_items"`
				} `json:"amount_items"`
			} `json:"amount_detail"`
			PaidAt     int         `json:"paid_at"`
			SentAt     interface{} `json:"sent_at"`
			ReceivedAt interface{} `json:"received_at"`
			ClosedAt   interface{} `json:"closed_at"`
			Button     []struct {
				Title string `json:"title"`
				Url   string `json:"url"`
			} `json:"button"`
		} `json:"read"`
	} `json:"data"`
}

// OrderDetail 订单详情
func (s *Client) OrderDetail(ctx context.Context, req string) (res *OrderDetailRes, err error) {
	var method = "/app/order/orderDetail"
	result, err := s.get(ctx, method, g.Map{
		"order_sn": req,
	})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderDetailV2Res struct {
	Code int `json:"code"`
	Data struct {
		Read []struct {
			Id                   int    `json:"id"`
			CreatedAt            int    `json:"created_at"`
			UpdatedAt            int    `json:"updated_at"`
			OrderSn              int64  `json:"order_sn"`
			ThirdOrderSn         string `json:"third_order_sn"`
			GatherSupplySn       string `json:"gather_supply_sn"`
			Status               int    `json:"status"`
			SendStatus           int    `json:"send_status"`
			SendStatusName       string `json:"send_status_name"`
			StatusName           string `json:"status_name"`
			Title                string `json:"title"`
			Freight              int    `json:"freight"`
			Amount               int    `json:"amount"`
			ItemAmount           int    `json:"item_amount"`
			SupplyAmount         int    `json:"supply_amount"`
			TechnicalServicesFee int    `json:"technical_services_fee"`
			Remark               string `json:"remark"`
			Note                 string `json:"note"`
			GoodsCount           int    `json:"goods_count"`
			UserId               int    `json:"user_id"`
			ShippingAddressId    int    `json:"shipping_address_id"`
			ShippingMethod       string `json:"shipping_method"`
			ShippingMethodId     int    `json:"shipping_method_id"`
			CommentStatus        int    `json:"comment_status"`
			OrderItems           []struct {
				Id             int    `json:"id"`
				OrderId        int    `json:"order_id"`
				Title          string `json:"title"`
				SkuTitle       string `json:"sku_title"`
				Unit           string `json:"unit"`
				Qty            int    `json:"qty"`
				Amount         int    `json:"amount"`
				Price          int    `json:"price"`
				ImageUrl       string `json:"image_url"`
				ProductId      int    `json:"product_id"`
				SupplyAmount   int    `json:"supply_amount"`
				SkuId          int    `json:"sku_id"`
				OrderExpressId int    `json:"order_express_id"`
				CommentStatus  int    `json:"comment_status"`
				RefundStatus   int    `json:"refund_status"`
				CanRefund      int    `json:"can_refund"`
				GatherSupplySn string `json:"gather_supply_sn"`
				RefundAmount   int    `json:"refund_amount"`
				SendStatus     int    `json:"send_status"`
				Options        []struct {
					SpecName     string `json:"spec_name"`
					SpecItemName string `json:"spec_item_name"`
				} `json:"options"`
				AfterSales struct {
					Id                   int         `json:"id"`
					CreatedAt            interface{} `json:"created_at"`
					UpdatedAt            interface{} `json:"updated_at"`
					AfterSaleSn          string      `json:"after_sale_sn"`
					UserId               int         `json:"user_id"`
					Amount               int         `json:"amount"`
					TechnicalServicesFee int         `json:"technical_services_fee"`
					Freight              int         `json:"freight"`
					PracticalAmount      int         `json:"practical_amount"`
					ReasonType           int         `json:"reason_type"`
					Reason               string      `json:"reason"`
					Description          string      `json:"description"`
					OrderId              int         `json:"order_id"`
					OrderItemId          int         `json:"order_item_id"`
					SkuId                int         `json:"sku_id"`
					ProductId            int         `json:"product_id"`
					ShippingAddressId    int         `json:"shipping_address_id"`
					IsReceived           int         `json:"is_received"`
					PayMethod            int         `json:"pay_method"`
					ReturnOrderExpressId int         `json:"return_order_express_id"`
					Status               int         `json:"status"`
					Type                 int         `json:"type"`
					DetailImages         interface{} `json:"detail_images"`
					Logs                 interface{} `json:"logs"`
					Num                  int         `json:"num"`
					AfterSalesAudit      struct {
						Id           int         `json:"id"`
						CreatedAt    interface{} `json:"created_at"`
						UpdatedAt    interface{} `json:"updated_at"`
						AfterSalesId int         `json:"after_sales_id"`
						AdminId      int         `json:"admin_id"`
						ReasonType   int         `json:"reason_type"`
						Reason       string      `json:"reason"`
						Status       int         `json:"status"`
						Cause        string      `json:"cause"`
						StatusName   string      `json:"status_name"`
						RefundName   string      `json:"refund_name"`
					} `json:"after_sales_audit"`
					ReturnOrderExpress struct {
						Id           int         `json:"id"`
						CreatedAt    interface{} `json:"created_at"`
						UpdatedAt    interface{} `json:"updated_at"`
						AfterSalesId int         `json:"after_sales_id"`
						CompanyName  string      `json:"company_name"`
						CompanyCode  string      `json:"company_code"`
						ExpressNo    string      `json:"express_no"`
					} `json:"return_order_express"`
					RefundReasonName     string      `json:"refund_reason_name"`
					SuccessAt            interface{} `json:"success_at"`
					StatusName           string      `json:"status_name"`
					NewShippingAddressId int         `json:"new_shipping_address_id"`
				} `json:"after_sales"`
				Sku struct {
					Id                    int         `json:"id"`
					CreatedAt             interface{} `json:"created_at"`
					UpdatedAt             interface{} `json:"updated_at"`
					Title                 string      `json:"title"`
					Price                 int         `json:"price"`
					CostPrice             int         `json:"cost_price"`
					OriginPrice           int         `json:"origin_price"`
					GuidePrice            int         `json:"guide_price"`
					ActivityPrice         int         `json:"activity_price"`
					Stock                 int         `json:"stock"`
					Weight                int         `json:"weight"`
					IsDisplay             int         `json:"is_display"`
					ProductId             int         `json:"product_id"`
					SupplierId            int         `json:"supplier_id"`
					Code                  string      `json:"code"`
					Sn                    string      `json:"sn"`
					Barcode               string      `json:"barcode"`
					ImageUrl              string      `json:"image_url"`
					Options               interface{} `json:"options"`
					OriginalSkuId         int         `json:"original_sku_id"`
					SpecId                string      `json:"specId"`
					Describe              string      `json:"describe"`
					TaxCode               string      `json:"tax_code"`
					TaxProductName        string      `json:"tax_product_name"`
					TaxShortName          string      `json:"tax_short_name"`
					TaxOption             string      `json:"tax_option"`
					TaxUnit               string      `json:"tax_unit"`
					FavorablePolicy       string      `json:"favorable_policy"`
					IsFavorablePolicy     int         `json:"is_favorable_policy"`
					FreeOfTax             int         `json:"free_of_tax"`
					ShortCode             string      `json:"short_code"`
					TaxMeasurePrice       int         `json:"tax_measure_price"`
					TaxRate               int         `json:"tax_rate"`
					IsTaxLogo             int         `json:"is_tax_logo"`
					ProfitRate            int         `json:"profit_rate"`
					JushuitanBind         int         `json:"jushuitan_bind"`
					JushuitanUploadStatus int         `json:"jushuitan_upload_status"`
					Desc                  string      `json:"desc"`
					Gallery               interface{} `json:"gallery"`
					VideoUrl              string      `json:"video_url"`
					Attrs                 interface{} `json:"attrs"`
					Number                int         `json:"number"`
				} `json:"sku"`
				TechnicalServicesFee int `json:"technical_services_fee"`
			} `json:"order_items"`
			OrderExpress    []interface{} `json:"order_express"`
			ShippingAddress struct {
				Id         int    `json:"id"`
				Realname   string `json:"realname"`
				Mobile     string `json:"mobile"`
				CountryId  int    `json:"country_id"`
				ProvinceId int    `json:"province_id"`
				CityId     int    `json:"city_id"`
				CountyId   int    `json:"county_id"`
				TownId     int    `json:"town_id"`
				Province   string `json:"province"`
				City       string `json:"city"`
				County     string `json:"county"`
				Town       string `json:"town"`
				Detail     string `json:"detail"`
				Lng        string `json:"lng"`
				Lat        string `json:"lat"`
			} `json:"shipping_address"`
			User struct {
				Id                int    `json:"id"`
				UpdatedAt         int    `json:"updated_at"`
				CreatedAt         int    `json:"created_at"`
				Mobile            string `json:"mobile"`
				Avatar            string `json:"avatar"`
				Username          string `json:"username"`
				Password          string `json:"password"`
				Nickname          string `json:"nickname"`
				Status            int    `json:"status"`
				Uuid              string `json:"uuid"`
				LevelId           int    `json:"level_id"`
				ParentId          int    `json:"parent_id"`
				TemporaryParentId int    `json:"temporary_parent_id"`
				QrCode            string `json:"qr_code"`
				InviteCode        string `json:"invite_code"`
				WxUsername        string `json:"wx_username"`
				UserLevel         struct {
					Id        int         `json:"id"`
					CreatedAt interface{} `json:"created_at"`
					UpdatedAt interface{} `json:"updated_at"`
					Discount  int         `json:"discount"`
					Name      string      `json:"name"`
					Level     int         `json:"level"`
				} `json:"user_level"`
				WxOpenid          string      `json:"wx_openid"`
				WxMiniOpenid      string      `json:"wx_mini_openid"`
				WxUnionid         string      `json:"wx_unionid"`
				IsPermanent       int         `json:"is_permanent"`
				UpgradeAt         interface{} `json:"UpgradeAt"`
				ValidityAt        interface{} `json:"validity_at"`
				Validity          string      `json:"validity"`
				FullName          string      `json:"full_name"`
				IdCard            string      `json:"id_card"`
				AliAccount        string      `json:"ali_account"`
				Remark            string      `json:"remark"`
				ThousandsPricesId int         `json:"thousands_prices_id"`
			} `json:"user"`
			PayTypeId    int `json:"pay_type_id"`
			AmountDetail struct {
				Title       string `json:"title"`
				Amount      int    `json:"amount"`
				Qty         int    `json:"qty"`
				Desc        string `json:"desc"`
				AmountItems []struct {
					Title       string      `json:"title"`
					Amount      int         `json:"amount"`
					Qty         int         `json:"qty"`
					Desc        string      `json:"desc"`
					AmountItems interface{} `json:"amount_items"`
				} `json:"amount_items"`
			} `json:"amount_detail"`
			PaidAt     int         `json:"paid_at"`
			SentAt     interface{} `json:"sent_at"`
			ReceivedAt interface{} `json:"received_at"`
			ClosedAt   interface{} `json:"closed_at"`
			Button     []struct {
				Title string `json:"title"`
				Url   string `json:"url"`
			} `json:"button"`
			OrderBill struct {
				Id          int    `json:"id"`
				CreatedAt   int    `json:"created_at"`
				UpdatedAt   int    `json:"updated_at"`
				Type        int    `json:"type"`
				AccountType int    `json:"account_type"`
				PersonName  string `json:"person_name"`
				Mobile      string `json:"mobile"`
				CompanyName string `json:"company_name"`
				CompanyCode string `json:"company_code"`
				Email       string `json:"email"`
				SignAddress string `json:"sign_address"`
				SignMobile  string `json:"sign_mobile"`
				OpeningBank string `json:"opening_bank"`
				BankAccount string `json:"bank_account"`
				DetailType  int    `json:"detail_type"`
				Amount      int    `json:"amount"`
				AddressId   int    `json:"address_id"`
				Applicant   string `json:"applicant"`
				OrderId     int    `json:"order_id"`
				BillId      int    `json:"bill_id"`
				Status      int    `json:"status"`
				Drawer      int    `json:"drawer"`
			} `json:"order_bill"`
			ApplicationId           int `json:"application_id"`
			IsUpdateShippingAddress int `json:"is_update_shipping_address"`
			GatherSupplyId          int `json:"gather_supply_id"`
			GatherSupply            struct {
				Id         int    `json:"id"`
				Name       string `json:"name"`
				Logo       string `json:"logo"`
				CategoryId int    `json:"category_id"`
			} `json:"gather_supply"`
			PayType           string `json:"pay_type"`
			ApplicationShopId int    `json:"application_shop_id"`
			ApplicationShop   struct {
				Id            int         `json:"id"`
				CreatedAt     interface{} `json:"created_at"`
				UpdatedAt     interface{} `json:"updated_at"`
				ApplicationId int         `json:"application_id"`
				ShopName      string      `json:"shop_name"`
				CallbackLink  string      `json:"callback_link"`
				AppSecret     string      `json:"app_secret"`
			} `json:"application_shop"`
			IsPlugin int `json:"is_plugin"`
		} `json:"read"`
	} `json:"data"`
	Msg string `json:"msg"`
}

// OrderDetailV2 通过第三方订单编号获取订单详情
func (s *Client) OrderDetailV2(ctx context.Context, req string) (res *OrderDetailV2Res, err error) {
	var method = "/app/order/orderDetailByThirdOrderSn"
	result, err := s.get(ctx, method, g.Map{
		"third_order_sn": req,
	})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
