package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type RefundCreateReq struct {
	BizClaimType      int32  //退款类型 1 仅退款，3 退货退款
	GoodsStatus       int32  //货物状态 4: 未发货, 1: 未收到货, 2: 已收到货
	OrderLineId       string //子分销订单 ID
	ApplyRefundCount  int32
	LeaveMessage      string
	ApplyReasonTextId int64
	ApplyReasonTips   string
	ApplyRefundFee    int64
	LeavePictureList  []string
}

type RefundCreateRes struct {
	OrderLineId   string `json:"orderLineId"`   //当前发起逆向的子分销订单号
	DisputeId     string `json:"disputeId"`     //纠纷 id
	DisputeStatus int    `json:"disputeStatus"` //逆向的状态 1-退货待处理 2-待买家退货 3-待商家收货 4-退款关闭 5-退款成功 6-已拒绝退款 17-取消退款中
	RequestId     string `json:"requestId"`
}

// Create 创建售后单
func (s refundTm) Create(ctx context.Context, req RefundCreateReq) (res *RefundCreateRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "CreateRefundOrder")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	Request := &client.CreateRefundOrderRequest{}
	var Body = new(client.RefundOrderCmd)

	Body.SetBizClaimType(req.BizClaimType)
	Body.SetGoodsStatus(req.GoodsStatus)
	Body.SetOrderLineId(req.OrderLineId)
	Body.SetApplyRefundCount(req.ApplyRefundCount)
	Body.SetLeaveMessage(req.LeaveMessage)
	Body.SetApplyReasonTextId(req.ApplyReasonTextId)
	Body.SetApplyReasonTips(req.ApplyReasonTips)
	Body.SetApplyRefundFee(req.ApplyRefundFee)
	var list []*client.LeavePictureList
	for _, item := range req.LeavePictureList {
		if item == "" {
			continue
		}
		list = append(list, &client.LeavePictureList{
			Picture: tea.String(item),
		})
	}
	if len(list) > 0 {
		Body.SetLeavePictureLists(list)
	}

	Request.SetBody(Body)

	r, err := server.CreateRefundOrder(Request)
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
