package tmv3

import (
	"context"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type RefundCancelRes struct {
	OrderLineId   string `json:"orderLineId"`   //当前发起逆向的子分销订单号
	DisputeId     string `json:"disputeId"`     //纠纷 id
	DisputeStatus int    `json:"disputeStatus"` //逆向的状态 1-退货待处理 2-待买家退货 3-待商家收货 4-退款关闭 5-退款成功 6-已拒绝退款 17-取消退款中
	RequestId     string `json:"requestId"`
}

// Cancel 取消售后单
func (s refundTm) Cancel(ctx context.Context, req RefundCommonReq) (res *RefundCancelRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "CancelRefundOrder")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()

	r, err := server.CancelRefundOrder(tea.String(req.DisputeId))
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
