package tmv3

import (
	"context"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type OrderStatusReq struct {
	PurchaseOrderId string //采购单 ID
}

type OrderStatusRes struct {
	RequestId string `json:"requestId"`
	Status    string `json:"status"`
	//1：分销单创建中。
	//10：采购中。
	//20：采购成功，待发货。
	//21：采购成功，部分发货。
	//22：采购成功，全部发货。
	//30：部分采购成功，待发货。
	//31：部分采购成功，部分发货。
	//32：部分采购成功，全部发货。
	//80：交易失败。
	//99：交易成功。
}

// Status 获取采购单状态
func (s orderTm) Status(ctx context.Context, req OrderStatusReq) (res *OrderStatusRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "GetPurchaseOrderStatus")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()

	r, err := server.GetPurchaseOrderStatus(tea.String(req.PurchaseOrderId))
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
