package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type SpuSaleInfoReq struct {
	ProductId    string
	PurchaserId  string
	DivisionCode string
}

type SpuSaleInfoRes struct {
	CanSell       bool   `json:"canSell"`
	FuzzyQuantity string `json:"fuzzyQuantity"`
	LmItemId      string `json:"lmItemId"`
	ProductId     string `json:"productId"`
	ProductStatus string `json:"productStatus"`
	Quantity      int    `json:"quantity"`
	RequestId     string `json:"requestId"`
	ShopId        string `json:"shopId"`
	Skus          []struct {
		CanSell       bool   `json:"canSell"`
		FuzzyQuantity string `json:"fuzzyQuantity"`
		MarkPrice     int    `json:"markPrice"`
		Price         int    `json:"price"`
		ProductId     string `json:"productId"`
		Quantity      int    `json:"quantity"`
		ShopId        string `json:"shopId"`
		SkuId         string `json:"skuId"`
		SkuStatus     string `json:"skuStatus"`
		Title         string `json:"title"`
	} `json:"skus"`
	Title string `json:"title"`
}

// SpuSaleInfo 查询选品池商品销售信息
func (s goodsTm) SpuSaleInfo(ctx context.Context, req SpuSaleInfoReq) (res *SpuSaleInfoRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "GetSelectionProductSaleInfo")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	if req.PurchaserId == "" {
		req.PurchaserId = PurchaserId
	}
	Request := &client.GetSelectionProductSaleInfoRequest{
		PurchaserId: tea.String(req.PurchaserId),
	}
	if req.DivisionCode != "" {
		Request.SetDivisionCode(req.DivisionCode)
	}
	r, err := server.GetSelectionProductSaleInfo(tea.String(req.ProductId), Request)
	if err != nil {
		return
	}
	err = gjson.New(r.Body).Scan(&res)
	return
}
