package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type GoodsDetailReq struct {
	ProductId    string
	PurchaserId  string
	DivisionCode string
}

type GoodsDetailRes struct {
	RequestId      string   `json:"requestId"`
	ProductId      string   `json:"productId"`
	Title          string   `json:"title"`
	PicUrl         string   `json:"picUrl"`
	DescPath       string   `json:"descPath"`
	CategoryLeafId int      `json:"categoryLeafId"`
	Images         []string `json:"images"`
	Properties     []struct {
		Text   string   `json:"text"`
		Values []string `json:"values"`
	} `json:"properties"`
	ProductSpecs []struct {
		KeyId  int    `json:"keyId"`
		Key    string `json:"key"`
		Values []struct {
			ValueId int    `json:"valueId"`
			Value   string `json:"value"`
		} `json:"values"`
	} `json:"productSpecs"`
	Skus []struct {
		ShopId    string `json:"shopId"`
		ProductId string `json:"productId"`
		SkuId     string `json:"skuId"`
		Title     string `json:"title"`
		PicUrl    string `json:"picUrl"`
		SkuSpecs  []struct {
			KeyId   int    `json:"keyId"`
			Key     string `json:"key"`
			ValueId int    `json:"valueId"`
			Value   string `json:"value"`
		} `json:"skuSpecs"`
		SkuSpecsCode  string `json:"skuSpecsCode"`
		SkuStatus     string `json:"skuStatus"`
		CanSell       bool   `json:"canSell"`
		Quantity      int    `json:"quantity"`
		FuzzyQuantity string `json:"fuzzyQuantity"`
		Price         int    `json:"price"`
		MarkPrice     int    `json:"markPrice"`
		PlatformPrice int    `json:"platformPrice"`
		DivisionCode  string `json:"divisionCode"`
	} `json:"skus"`
	CanSell       bool        `json:"canSell"`
	ProductType   string      `json:"productType"`
	ProductStatus string      `json:"productStatus"`
	ShopId        string      `json:"shopId"`
	Quantity      int         `json:"quantity"`
	FuzzyQuantity string      `json:"fuzzyQuantity"`
	TaxRate       interface{} `json:"taxRate"`
	TaxCode       interface{} `json:"taxCode"`
	CategoryChain []struct {
		CategoryId int    `json:"categoryId"`
		Name       string `json:"name"`
		ParentId   int    `json:"parentId"`
		Level      int    `json:"level"`
		IsLeaf     bool   `json:"isLeaf"`
	} `json:"categoryChain"`
	SoldQuantity string `json:"soldQuantity"`
	DivisionCode string `json:"divisionCode"`
}

// Detail 查询选品池商品详情
func (s goodsTm) Detail(ctx context.Context, req GoodsDetailReq) (res *GoodsDetailRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "GetSelectionProduct")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	if req.PurchaserId == "" {
		req.PurchaserId = PurchaserId
	}
	Request := &client.GetSelectionProductRequest{
		PurchaserId: tea.String(req.PurchaserId),
	}
	if req.DivisionCode != "" {
		Request.SetDivisionCode(req.DivisionCode)
	}
	r, err := server.GetSelectionProduct(tea.String(req.ProductId), Request)
	if err != nil {
		return
	}
	err = gjson.New(r.Body).Scan(&res)
	return
}
