package yunzmall

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type refundLogic struct {
}

type RefundBeforeRes struct {
	CommonRes
	Data map[string]string `json:"data"`
}

func (s *Client) RefundBefore(ctx context.Context, req string) (res *RefundBeforeRes, err error) {
	var method = "/app/afterSales/getAfterSalesTypeNameMap"
	result, err := s.get(ctx, method, g.Map{
		"order_item_id": req,
	})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type RefundDetailRes struct {
	CommonRes
	Data struct {
		AfterSales struct {
			Id                   int         `json:"id"`
			CreatedAt            int         `json:"created_at"`
			UpdatedAt            int         `json:"updated_at"`
			AfterSaleSn          string      `json:"after_sale_sn"`
			UserId               int         `json:"user_id"`
			Amount               int         `json:"amount"`
			PracticalAmount      int         `json:"practical_amount"`
			ReasonType           int         `json:"reason_type"`
			Reason               string      `json:"reason"`
			Description          string      `json:"description"`
			OrderId              int         `json:"order_id"`
			OrderItemId          int         `json:"order_item_id"`
			SkuId                int         `json:"sku_id"`
			ProductId            int         `json:"product_id"`
			ShippingAddressId    int         `json:"shipping_address_id"`
			IsReceived           int         `json:"is_received"`
			PayMethod            int         `json:"pay_method"`
			ReturnOrderExpressId int         `json:"return_order_express_id"`
			Status               int         `json:"status"`
			Type                 int         `json:"type"`
			DetailImages         interface{} `json:"detail_images"`
			Logs                 []struct {
				CreatedAt      string `json:"created_at"`
				AdminId        int    `json:"admin_id"`
				Content        string `json:"content"`
				Price          int    `json:"price"`
				RefundTypeName string `json:"refund_type_name"`
				ReasonTypeName string `json:"reason_type_name"`
				Description    string `json:"description"`
			} `json:"logs"`
			User struct {
				Id       int    `json:"id"`
				Avatar   string `json:"avatar"`
				Username string `json:"username"`
				Nickname string `json:"nickname"`
			} `json:"user"`
			RefundReasonName string      `json:"refund_reason_name"`
			SuccessAt        interface{} `json:"success_at"`
			StatusName       string      `json:"status_name"`
			Order            struct {
				Id            int   `json:"id"`
				OrderSn       int64 `json:"order_sn"`
				ApplicationId int   `json:"application_id"`
			} `json:"order"`
			OrderItem struct {
				Id         int    `json:"id"`
				SkuTitle   string `json:"sku_title"`
				Title      string `json:"title"`
				ProductId  int    `json:"product_id"`
				OrderId    int    `json:"order_id"`
				ImageUrl   string `json:"image_url"`
				SendStatus int    `json:"send_status"`
				Amount     int    `json:"amount"`
			} `json:"order_item"`
			AfterSalesAudit struct {
				Id           int    `json:"id"`
				CreatedAt    int    `json:"created_at"`
				UpdatedAt    int    `json:"updated_at"`
				AfterSalesId int    `json:"after_sales_id"`
				AdminId      int    `json:"admin_id"`
				ReasonType   int    `json:"reason_type"`
				Reason       string `json:"reason"`
				Status       int    `json:"status"`
				Cause        string `json:"cause"`
				StatusName   string `json:"status_name"`
				RefundName   string `json:"refund_name"`
			} `json:"after_sales_audit"`
			ReturnOrderExpress struct {
				Id           int         `json:"id"`
				CreatedAt    interface{} `json:"created_at"`
				UpdatedAt    interface{} `json:"updated_at"`
				AfterSalesId int         `json:"after_sales_id"`
				CompanyName  string      `json:"company_name"`
				CompanyCode  string      `json:"company_code"`
				ExpressNo    string      `json:"express_no"`
			} `json:"return_order_express"`
		} `json:"after_sales"`
	} `json:"data"`
}

// RefundDetail 详情
func (s *Client) RefundDetail(ctx context.Context, req interface{}) (res *RefundDetailRes, err error) {
	var method = "/app/afterSales/get"
	result, err := s.get(ctx, method, g.Map{
		"id": gconv.Int(req),
	})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type RefundAddressRes struct {
	CommonRes
	Data struct {
		Id           int      `json:"id"`
		Contacts     string   `json:"contacts"`
		Tel          string   `json:"tel"`
		Plane        string   `json:"plane"`
		Country      string   `json:"country"`
		Province     int      `json:"province"`
		City         int      `json:"city"`
		District     int      `json:"district"`
		Address      string   `json:"address"`
		AddressType  []string `json:"address_type"`
		IsDefault    int      `json:"is_default"`
		SupplierId   int      `json:"supplier_id"`
		ProvinceName struct {
			Id       int    `json:"id"`
			ParentId int    `json:"parent_id"`
			Name     string `json:"name"`
			Level    int    `json:"level"`
		} `json:"province_name"`
		CityName struct {
			Id       int    `json:"id"`
			ParentId int    `json:"parent_id"`
			Name     string `json:"name"`
			Level    int    `json:"level"`
		} `json:"city_name"`
		DistrictName struct {
			Id       int    `json:"id"`
			ParentId int    `json:"parent_id"`
			Name     string `json:"name"`
			Level    int    `json:"level"`
		} `json:"district_name"`
		Supplier struct {
			Id       int    `json:"id"`
			Name     string `json:"name"`
			Supplier string `json:"supplier"`
		} `json:"supplier"`
	} `json:"data"`
}

// RefundAddress 退货地址
func (s *Client) RefundAddress(ctx context.Context, req interface{}) (res *RefundAddressRes, err error) {
	var method = "/app/supplier/findShopAddressByOrderId"
	result, err := s.get(ctx, method, g.Map{
		"after_sales_id": gconv.Int(req),
	})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type RefundReasonRes struct {
	Code int `json:"code"`
	Data struct {
		Reasons map[string]string `json:"reasons"`
	} `json:"data"`
	Msg string `json:"msg"`
}

// RefundReason 售后原因
func (s *Client) RefundReason(ctx context.Context, afterSaleType, isReceived int) (res *RefundReasonRes, err error) {
	var method = "/app/afterSales/reason/list"
	result, err := s.get(ctx, method, g.Map{
		"after_sale_type": afterSaleType,
		"is_received":     isReceived,
	})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type RefundCreateReq struct {
	OrderId      int      `json:"order_id,omitempty"`       //订单id
	ThirdOrderSn string   `json:"third_order_sn,omitempty"` //采购端订单号
	OrderItemId  int      `json:"order_item_id"`            //子订单id
	ReasonType   int      `json:"reason_type"`              //售后原因
	Description  string   `json:"description"`              //描述
	Reason       string   `json:"reason"`                   //售后原因是 其他的的时候填写
	RefundType   int      `json:"refund_type"`              //退款还是退货退款
	IsReceived   int      `json:"is_received"`              //是否收到货 1是0否
	DetailImages []string `json:"detail_images,omitempty"`  //图片凭证
	RefundWay    int      `json:"refund_way,omitempty"`     //退款方式
	Num          int      `json:"num"`                      //退款商品个数
	BarterSkuId  int      `json:"barter_sku_id,omitempty"`  //换货中台规格id
	BarterNum    int      `json:"barter_num,omitempty"`     //换货数量
}

type RefundCreateRes struct {
	CommonRes
	Data int `json:"data"`
}

// RefundCreate 申请售后
func (s *Client) RefundCreate(ctx context.Context, req RefundCreateReq) (res *RefundCreateRes, err error) {
	var method = "/app/afterSales/create"
	result, err := s.post(ctx, method, gconv.Map(req))
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type RefundSendReq struct {
	AfterSalesID      int    `json:"after_sales_id"`      //售后id
	CompanyName       string `json:"company_name"`        //物流公司名称
	CompanyCode       string `json:"company_code"`        //物流公司code
	ExpressNo         string `json:"express_no"`          //物流单号
	ShippingAddressID int    `json:"shipping_address_id"` //售后商家收货地址 通过售后id获取默认商家售后退货地址 获得
}

// RefundSend 售后发货
func (s *Client) RefundSend(ctx context.Context, req RefundSendReq) (res *CommonRes, err error) {
	var method = "app/afterSales/send"
	result, err := s.post(ctx, method, gconv.Map(req))
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
