package schl

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type categoryLogic struct {
}

var Category = categoryLogic{}

type CategoryListRes struct {
	CommonRes
	Result []CategoryListItem `json:"result"`
}
type CategoryListItem struct {
	Id    int    `json:"id"`
	Img   string `json:"img"`
	Name  string `json:"name"`
	SupId int    `json:"supId"`
}

// CategoryList 获取商品分类
func (s *Config) CategoryList(ctx context.Context) (res *CategoryListRes, err error) {
	result, err := s.Post(ctx, "/open/xdxt/api/v2/goods/listGoodsCategory", g.Map{})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
