package yz

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/frame/g"
)

type orderLogic struct {
}

var Order = orderLogic{}

type OrderDetailRes struct {
	TraceId string `json:"trace_id"`
	Code    int    `json:"code"`
	Data    struct {
		DeliveryOrder  []interface{} `json:"delivery_order"`
		OrderPromotion struct {
			Item               []interface{} `json:"item"`
			AdjustFee          string        `json:"adjust_fee"`
			OrderPaidPromotion []interface{} `json:"order_paid_promotion"`
			Order              []interface{} `json:"order"`
		} `json:"order_promotion"`
		CustomItemInfos []interface{} `json:"custom_item_infos"`
		RefundOrder     []interface{} `json:"refund_order"`
		FullOrderInfo   struct {
			ChildInfo struct {
				ChildOrders []interface{} `json:"child_orders"`
			} `json:"child_info"`
			RemarkInfo struct {
				BuyerMessage string `json:"buyer_message"`
			} `json:"remark_info"`
			AddressInfo struct {
				SelfFetchInfo      string `json:"self_fetch_info"`
				DeliveryAddress    string `json:"delivery_address"`
				DeliveryPostalCode string `json:"delivery_postal_code"`
				ReceiverName       string `json:"receiver_name"`
				DeliveryProvince   string `json:"delivery_province"`
				DeliveryCity       string `json:"delivery_city"`
				DeliveryDistrict   string `json:"delivery_district"`
				AddressExtra       string `json:"address_extra"`
				ReceiverTel        string `json:"receiver_tel"`
			} `json:"address_info"`
			PayInfo struct {
				OuterTransactions []string      `json:"outer_transactions"`
				DeductionRealPay  int           `json:"deduction_real_pay"`
				RealPayment       string        `json:"real_payment"`
				PostFee           string        `json:"post_fee"`
				DeductionPay      int           `json:"deduction_pay"`
				PhasePayments     []interface{} `json:"phase_payments"`
				TotalFee          string        `json:"total_fee"`
				Payment           string        `json:"payment"`
				Transaction       []string      `json:"transaction"`
			} `json:"pay_info"`
			BuyerInfo struct {
				OuterUserId  string `json:"outer_user_id"`
				BuyerPhone   string `json:"buyer_phone"`
				YzOpenId     string `json:"yz_open_id"`
				FansType     int    `json:"fans_type"`
				FansNickname string `json:"fans_nickname"`
				FansId       int    `json:"fans_id"`
			} `json:"buyer_info"`
			Orders []struct {
				GoodsCostPrice       string `json:"goods_cost_price"`
				IsCrossBorder        string `json:"is_cross_border"`
				OuterItemId          string `json:"outer_item_id"`
				ItemType             int    `json:"item_type"`
				DiscountPrice        string `json:"discount_price"`
				GoodsDate            string `json:"goods_date"`
				WarehouseCode        string `json:"warehouse_code"`
				Num                  int    `json:"num"`
				Oid                  string `json:"oid"`
				GoodsSnapshot        string `json:"goods_snapshot"`
				Title                string `json:"title"`
				FenxiaoPayment       string `json:"fenxiao_payment"`
				ItemNo               string `json:"item_no"`
				BuyerMessages        string `json:"buyer_messages"`
				RootSkuId            string `json:"root_sku_id"`
				IsPresent            bool   `json:"is_present"`
				CrossBorderTradeMode string `json:"cross_border_trade_mode"`
				Price                string `json:"price"`
				SubOrderNo           string `json:"sub_order_no"`
				TotalFee             string `json:"total_fee"`
				FenxiaoPrice         string `json:"fenxiao_price"`
				SalePlan             struct {
					Penalty struct {
					} `json:"penalty"`
					CancelRuleTime struct {
					} `json:"cancel_rule_time"`
				} `json:"sale_plan"`
				Alias             string `json:"alias"`
				Payment           string `json:"payment"`
				ItemBarcode       string `json:"item_barcode"`
				IsPreSale         string `json:"is_pre_sale"`
				OuterSkuId        string `json:"outer_sku_id"`
				SkuUniqueCode     string `json:"sku_unique_code"`
				GoodsUrl          string `json:"goods_url"`
				CustomsCode       string `json:"customs_code"`
				IsPriceCalendar   string `json:"is_price_calendar"`
				ItemId            int64  `json:"item_id"`
				Weight            string `json:"weight"`
				SkuId             int    `json:"sku_id"`
				SkuPropertiesName string `json:"sku_properties_name"`
				PicPath           string `json:"pic_path"`
				ShopOrgId         string `json:"shop_org_id"`
				OuterOid          string `json:"outer_oid"`
				PreSaleType       string `json:"pre_sale_type"`
				PointsPrice       string `json:"points_price"`
				SkuNo             string `json:"sku_no"`
				RootItemId        string `json:"root_item_id"`
				SkuBarcode        string `json:"sku_barcode"`
				ItemProps         string `json:"item_props"`
			} `json:"orders"`
			SourceInfo struct {
				IsOfflineOrder bool   `json:"is_offline_order"`
				BookKey        string `json:"book_key"`
				BizSource      string `json:"biz_source"`
				Source         struct {
					Platform   string `json:"platform"`
					WxEntrance string `json:"wx_entrance"`
				} `json:"source"`
			} `json:"source_info"`
			OrderInfo struct {
				ConsignTime string `json:"consign_time"`
				OrderExtra  struct {
					IsFromCart           string `json:"is_from_cart"`
					BuyerName            string `json:"buyer_name"`
					ForceConsignmentMode string `json:"force_consignment_mode"`
					IsPointsOrder        string `json:"is_points_order"`
				} `json:"order_extra"`
				ExpiredTime   string `json:"expired_time"`
				Type          int    `json:"type"`
				Tid           string `json:"tid"`
				NodeKdtId     int    `json:"node_kdt_id"`
				UpdateTime    string `json:"update_time"`
				PayTypeStr    string `json:"pay_type_str"`
				PayType       int    `json:"pay_type"`
				TeamType      int    `json:"team_type"`
				ChannelType   int    `json:"channel_type"`
				Created       string `json:"created"`
				StatusStr     string `json:"status_str"`
				SuccessTime   string `json:"success_time"`
				ShopName      string `json:"shop_name"`
				ConfirmTime   string `json:"confirm_time"`
				PayTime       string `json:"pay_time"`
				IsRetailOrder bool   `json:"is_retail_order"`
				PayTypeDesc   string `json:"pay_type_desc"`
				RefundState   int    `json:"refund_state"`
				RootKdtId     int    `json:"root_kdt_id"`
				CloseType     int    `json:"close_type"`
				Status        string `json:"status"` //主订单状态： WAIT_BUYER_PAY：等待买家付款，定金预售描述：定金待付、等待尾款支付开始、尾款待付， TRADE_PAID：订单已支付 ，该状态仅代表当前订单已支付成功，表示瞬时状态，稍后会自动修改成后面的状态。如果不关心此状态请再次请求详情接口获取下一个状态， WAIT_CONFIRM：待确认，包含待成团、待接单等等。即：买家已付款，等待成团或等待接单， WAIT_SELLER_SEND_GOODS：等待卖家发货，即：买家已付款， WAIT_BUYER_CONFIRM_GOODS 等待买家确认收货，即：卖家已发货， TRADE_SUCCESS：买家已签收以及订单成功， TRADE_CLOSED：交易关闭
				ExpressType   int    `json:"express_type"`
				OrderTags     struct {
					IsMember              bool `json:"is_member"`
					IsSecuredTransactions bool `json:"is_secured_transactions"`
					IsPayed               bool `json:"is_payed"`
				} `json:"order_tags"`
			} `json:"order_info"`
		} `json:"full_order_info"`
	} `json:"data"`
	Success bool   `json:"success"`
	Message string `json:"message"`
}

func (s orderLogic) Detail(ctx context.Context, req string) (res *OrderDetailRes, err error) {
	method := "youzan.trade.get/4.0.2"
	result, err := server.requestApi(ctx, method, g.Map{
		"tid": req,
	})
	if err != nil {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}
