package yunzmall

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type storageLogic struct {
}

// StorageAdd 添加选品库商品
func (s *Client) StorageAdd(ctx context.Context, req interface{}) (res *CommonRes, err error) {
	var method = "/app/product/storage/addStorage"
	result, err := s.post(ctx, method, g.Map{
		"ids": gconv.Ints(req),
	})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

// StorageDelete 删除选品库商品
func (s *Client) StorageDelete(ctx context.Context, req interface{}) (res *CommonRes, err error) {
	var method = "/app/product/storage/deleteStorage"
	result, err := s.post(ctx, method, g.Map{
		"ids": gconv.Ints(req),
	})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
