package wpc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type addressWpc struct {
}

var Address = addressWpc{}

type AddressListReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	AreaCode   string `json:"areaCode,omitempty"`
}

type AddressListRes struct {
	ReturnCode    string `json:"returnCode"`
	ReturnMessage string `json:"returnMessage"`
	Result        struct {
		ChildList []struct {
			AreaCode string `json:"areaCode"`
			AreaName string `json:"areaName"`
		} `json:"childList"`
		Info struct {
			AreaCode string `json:"areaCode"`
			AreaName string `json:"areaName"`
		} `json:"info"`
	} `json:"result"`
}

func (*addressWpc) List(ctx context.Context, req AddressListReq) (res *AddressListRes, err error) {
	method := "selectAddress"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type AddressParseReq struct {
	ChannelId   string `json:"vopChannelId"`
	UserNumber  string `json:"userNumber"`
	FullAddress string `json:"fullAddress"`
}

type AddressParseRes struct {
	ReturnCode    string `json:"returnCode"`
	ReturnMessage string `json:"returnMessage"`
	Result        struct {
		AreaCode     string `json:"areaCode"`
		TownName     string `json:"townName"`
		CityName     string `json:"cityName"`
		AreaName     string `json:"areaName"`
		TownCode     string `json:"townCode"`
		ProvinceCode string `json:"provinceCode"`
		CityCode     string `json:"cityCode"`
		ProvinceName string `json:"provinceName"`
	} `json:"result"`
}

//Parse  解析地址
func (*addressWpc) Parse(ctx context.Context, addr string) (res *AddressParseRes, err error) {
	method := "smartAddress"
	req := AddressParseReq{}
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	req.FullAddress = addr
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
