package wpc

import (
	"context"
	"crypto/hmac"
	"crypto/md5"
	"encoding/hex"
	"github.com/gogf/gf/container/garray"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/text/gstr"
	"github.com/gogf/gf/util/gconv"
	"net/url"
	"time"
)

type Config struct {
	ApiUrl      string
	AppKey      string
	UserNumber  string
	AppSecret   string
	AccessToken string
}

type QueryParam struct {
	AccessToken string `json:"accessToken"`
	AppKey      string `json:"appKey"`
	Format      string `json:"format"`
	Method      string `json:"method"`
	Service     string `json:"service"`
	Timestamp   int64  `json:"timestamp"`
	Version     string `json:"version"`
}

var server *Config

const service = "com.vip.wpc.ospservice.vop.WpcVopOspService"
const version = "1.0.0"
const format = "json"

const pkgName = "wpc"

func New(config *Config) {
	server = config
	return
}

func getQueryParam(method string) (res *QueryParam) {
	return &QueryParam{
		Service:     service,
		Method:      method,
		Version:     version,
		Timestamp:   gtime.Timestamp(),
		Format:      format,
		AppKey:      server.AppKey,
		AccessToken: server.AccessToken,
	}
}

func sign(param *QueryParam, req string) string {
	Map := gjson.New(param).Map()

	var keys = garray.NewStrArray()
	for k := range Map {
		keys.Append(k)
	}
	keys.Sort()
	var signStr string
	u := url.Values{}
	for _, v := range keys.Slice() {
		if val := gconv.String(Map[v]); val != "" {
			signStr += v
			signStr += val
			u.Set(v, val)
		}
	}
	signStr += req
	h := hmac.New(md5.New, []byte(server.AppSecret))
	h.Write([]byte(signStr))
	u.Set("sign", gstr.ToUpper(hex.EncodeToString(h.Sum([]byte("")))))
	return u.Encode()
}

func post(ctx context.Context, method string, req interface{}) (res string, err error) {
	Start := gtime.TimestampMilli()
	var Query = getQueryParam(method)
	paramStr := gjson.New(req).MustToJsonString()
	Url := server.ApiUrl + "?" + sign(Query, paramStr)
	Request := g.Client()
	Request.SetHeader("Content-Type", "application/json")
	resp, err := Request.Timeout(time.Second*5).Post(Url, gjson.New(req).MustToJsonString())
	defer func() {
		_ = resp.Close()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", method)
		if err != nil {
			g.Log().Ctx(ctx).Cat(pkgName).Cat("error").Infof("参数【%v】错误【%v】响应时间【%v】", paramStr, err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Ctx(ctx).Cat(pkgName).Infof("参数【%v】响应【%v】响应时间【%v】", paramStr, res, gtime.TimestampMilli()-Start)
		}
	}()
	res = resp.ReadAllString()
	return
}
