package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type RefundBeforeReq struct {
	BizClaimType int32  //退款类型 1 仅退款，3 退货退款
	GoodsStatus  int32  //货物状态 4: 未发货, 1: 未收到货, 2: 已收到货
	OrderLineId  string //子分销订单 ID
}

type RefundBeforeRes struct {
	RequestId        string `json:"requestId"`
	OrderLineId      string `json:"orderLineId"`  //子分销订单号
	BizClaimType     int    `json:"bizClaimType"` //支持的订单退货方式
	MaxRefundFeeData struct {
		MaxRefundFee int `json:"maxRefundFee"`
		MinRefundFee int `json:"minRefundFee"`
	} `json:"maxRefundFeeData"`
	RefundReasonList []struct { //退款理由
		ReasonTextId       string `json:"reasonTextId"`       //理由文本 id
		ProofRequired      bool   `json:"proofRequired"`      //是否要求上传凭证
		ReasonTips         string `json:"reasonTips"`         //理由文本
		RefundDescRequired bool   `json:"refundDescRequired"` //是否要求留言
	} `json:"refundReasonList"`
}

// Before 售后单渲染
func (s refundTm) Before(ctx context.Context, req RefundBeforeReq) (res *RefundBeforeRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "RenderRefundOrder")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	Request := &client.RenderRefundOrderRequest{}
	var Body = new(client.RefundRenderCmd)

	Body.SetBizClaimType(req.BizClaimType)
	Body.SetGoodsStatus(req.GoodsStatus)
	Body.SetOrderLineId(req.OrderLineId)

	Request.SetBody(Body)

	r, err := server.RenderRefundOrder(Request)
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
