package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type OrderListReq struct {
	PageNumber  int32
	PageSize    int32
	OrderIdList []string
}

// List 查询订单列表
func (s orderTm) List(ctx context.Context, req OrderListReq) (res *OrderDetailRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "QueryOrders")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()

	if req.PageNumber == 0 {
		req.PageNumber = 1
	}
	if req.PageSize == 0 {
		req.PageSize = 10
	}

	Request := &client.QueryOrdersRequest{}
	var Body = new(client.OrderPageQuery)
	Body.SetPageNumber(req.PageNumber)
	Body.SetPageSize(req.PageSize)
	var list []*string
	for _, item := range req.OrderIdList {
		list = append(list, tea.String(item))
	}
	Body.SetOrderIdList(list)
	Request.SetBody(Body)

	r, err := server.QueryOrders(Request)
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
