package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/util/gconv"
)

type OrderCreateReq struct {
	DeliveryAddress      OrderDeliveryAddress `json:"deliveryAddress"`
	BuyerId              string               `json:"buyerId"`
	ProductList          []OrderItem          `json:"productList"`
	OuterPurchaseOrderId string
}

type OrderCreateRes struct {
	OuterPurchaseOrderId string `json:"outerPurchaseOrderId"`
	DeliveryAddress      struct {
		DivisionCode     string `json:"divisionCode"`
		AddressDetail    string `json:"addressDetail"`
		ReceiverPhone    string `json:"receiverPhone"`
		Receiver         string `json:"receiver"`
		TownDivisionCode string `json:"townDivisionCode"`
	} `json:"deliveryAddress"`
	BuyerId     string `json:"buyerId"`
	ProductList []struct {
		Quantity    int    `json:"quantity"`
		ProductId   string `json:"productId"`
		PurchaserId string `json:"purchaserId"`
		SkuId       string `json:"skuId"`
	} `json:"productList"`
}

// Create 创建采购单
func (s orderTm) Create(ctx context.Context, req OrderCreateReq) (res *OrderCreateRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "CreatePurchaseOrder")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	Request := &client.CreatePurchaseOrderRequest{}
	var Body = new(client.PurchaseOrderCreateCmd)
	Body.SetBuyerId(req.BuyerId)
	Body.SetOuterPurchaseOrderId(req.OuterPurchaseOrderId)

	var DeliveryAddress = new(client.AddressInfo)
	DeliveryAddress.SetDivisionCode(req.DeliveryAddress.DivisionCode)
	DeliveryAddress.SetAddressDetail(req.DeliveryAddress.AddressDetail)
	DeliveryAddress.SetReceiverPhone(req.DeliveryAddress.ReceiverPhone)
	DeliveryAddress.SetReceiver(req.DeliveryAddress.Receiver)
	DeliveryAddress.SetTownDivisionCode(req.DeliveryAddress.TownDivisionCode)
	Body.SetDeliveryAddress(DeliveryAddress)

	var list []*client.ProductDTO
	for _, item := range req.ProductList {
		list = append(list, &client.ProductDTO{
			ProductId:   tea.String(item.ProductId),
			PurchaserId: tea.String(PurchaserId),
			Quantity:    tea.Int32(gconv.Int32(item.Quantity)),
			SkuId:       tea.String(item.SkuId),
		})
	}
	Body.SetProductList(list)
	Request.SetBody(Body)

	r, err := server.CreatePurchaseOrder(Request)
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
