package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/util/gconv"
)

type OrderBeforeReq struct {
	DeliveryAddress OrderDeliveryAddress `json:"deliveryAddress"`
	BuyerId         string               `json:"buyerId"`
	ProductList     []OrderItem          `json:"productList"`
}

type OrderBeforeRes struct {
	DeliveryAddress struct {
		DivisionCode     string `json:"divisionCode"`
		AddressDetail    string `json:"addressDetail"`
		ReceiverPhone    string `json:"receiverPhone"`
		Receiver         string `json:"receiver"`
		TownDivisionCode string `json:"townDivisionCode"`
	} `json:"deliveryAddress"`
	BuyerId     string `json:"buyerId"`
	ProductList []struct {
		Quantity    int    `json:"quantity"`
		ProductId   string `json:"productId"`
		PurchaserId string `json:"purchaserId"`
		SkuId       string `json:"skuId"`
	} `json:"productList"`
}

// Before 采购单渲染
func (s orderTm) Before(ctx context.Context, req OrderBeforeReq) (res *OrderBeforeRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "RenderPurchaseOrder")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	Request := &client.RenderPurchaseOrderRequest{}
	var Body = new(client.PurchaseOrderRenderQuery)
	Body.SetBuyerId(req.BuyerId)

	var DeliveryAddress = new(client.AddressInfo)
	DeliveryAddress.SetDivisionCode(req.DeliveryAddress.DivisionCode)
	DeliveryAddress.SetAddressDetail(req.DeliveryAddress.AddressDetail)
	DeliveryAddress.SetReceiverPhone(req.DeliveryAddress.ReceiverPhone)
	DeliveryAddress.SetReceiver(req.DeliveryAddress.Receiver)
	DeliveryAddress.SetTownDivisionCode(req.DeliveryAddress.TownDivisionCode)
	Body.SetDeliveryAddress(DeliveryAddress)

	var list []*client.OrderRenderProductDTO
	for _, item := range req.ProductList {
		list = append(list, &client.OrderRenderProductDTO{
			ProductId:   tea.String(item.ProductId),
			PurchaserId: tea.String(PurchaserId),
			Quantity:    tea.Int32(gconv.Int32(item.Quantity)),
			SkuId:       tea.String(item.SkuId),
		})
	}
	Body.SetProductList(list)
	Request.SetBody(Body)

	r, err := server.RenderPurchaseOrder(Request)
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
