package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type LogisticsConfirmReq struct {
	OrderId string
}

// Confirm  确认收货
func (s logisticsTm) Confirm(ctx context.Context, req LogisticsConfirmReq) (res *LogisticsTraceRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "ConfirmDisburse")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	Request := &client.ConfirmDisburseRequest{}
	var Body = new(client.ConfirmDisburseCmd)
	Body.SetOrderId(req.OrderId)
	Request.SetBody(Body)

	r, err := server.ConfirmDisburse(Request)
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
