package tm

import (
	"context"
	"encoding/json"
	link "github.com/alibabacloud-go/linkedmall-20220531/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
)

type category struct {
}

var Category = category{}

type QueryMallCategoryListRes struct {
	RequestId string `json:"RequestId"`
	Message   string `json:"Message"`
	Model     []struct {
		CategoryId int    `json:"CategoryId"`
		ParentId   int    `json:"ParentId"`
		Leaf       bool   `json:"Leaf"`
		Name       string `json:"Name"`
	} `json:"Model"`
	Code    string `json:"Code"`
	Success bool   `json:"Success"`
}


//区域库存商品详情
func (s *category) QueryMallCategoryList(ctx context.Context,item int64) (res *QueryMallCategoryListRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}
	result ,err :=client.QueryMallCategoryList(&link.QueryMallCategoryListRequest{
		DistributionMallId: tea.String(server.DistributionMallId),
		DistributorId:      tea.String(server.DistributorId),
		CategoryId:           tea.Int64(item),
		TenantId: tea.String(server.TenantId),
	})

	if result==nil{
		return
	}
	log(ctx,gjson.New(item).MustToJsonString(),result.Body,err)
	if err!=nil{
		return
	}
	a,_ :=json.Marshal(result.Body)
	if err = json.Unmarshal([]byte(a), &res); err != nil {
		return
	}
	return
}
type CategoryListRes struct {
	Code         string `json:"Code"` //成功 0000
	Message      string `json:"Message"`
	RequestId    string `json:"RequestId"`
	CategoryList struct {
		Category []struct {
			CategoryId int    `json:"CategoryId"`
			Name       string `json:"Name"`
		} `json:"Category"`
	} `json:"CategoryList"`
}

//func (category) List(ctx context.Context, req string) (res *CategoryListRes, err error) {
//	method := "GetCategoryList"
//
//	request := map[string]string{
//		"CategoryId": req,
//	}
//
//	result, err := post(ctx, method, request)
//	err = gjson.New(result).Scan(&res)
//	return
//}
