package yz

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/frame/g"
)

type secretLogic struct {
}

var Secret = secretLogic{}

type SecretDecryptRes struct {
	TraceId string `json:"trace_id"`
	Code    int    `json:"code"`
	Data    string `json:"data"`
	Success bool   `json:"success"`
	Message string `json:"message"`
}

func (s secretLogic) Decrypt(ctx context.Context, req string) (res *SecretDecryptRes, err error) {
	method := "youzan.cloud.secret.decrypt.single/1.0.0"
	result, err := server.requestApi(ctx, method, g.Map{
		"source": req,
	})
	if err != nil {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}

type SecretDecryptBatchRes struct {
	TraceId string            `json:"trace_id"`
	Code    int               `json:"code"`
	Data    map[string]string `json:"data"`
	Success bool              `json:"success"`
	Message string            `json:"message"`
}

func (s secretLogic) DecryptBatch(ctx context.Context, req []string) (res *SecretDecryptBatchRes, err error) {
	method := "youzan.cloud.secret.decrypt.batch/1.0.0"
	result, err := server.requestApi(ctx, method, g.Map{
		"sources": req,
	})
	if err != nil {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}
