package itao

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type refund struct {
}

var Refund = refund{}

type RefundPic struct {
	MessagePic string `json:"messagePic"`
}

type RefundBeforeRes struct {
	CommonRes
	Result struct {
		BizClaimTypeVOList []struct {
			BizClaimType    string `json:"bizClaimType"` //refund 仅退款 return_and_refund 退货退款
			RefundTypeTitle string `json:"refundTypeTitle"`
		} `json:"bizClaimTypeVOList"`
	} `json:"result"`
}

//Before 退款类型
func (s refund) Before(ctx context.Context, req string) (res *RefundBeforeRes, err error) {
	method := "tt.refund.refundApplyType"

	result, err := server.Post(ctx, method, g.Map{
		"request": g.Map{
			"bizOrderId": req,
		},
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}

type RefundReasonReq struct {
	BizOrderId       string `json:"bizOrderId"`
	BizClaimType     string `json:"bizClaimType"`
	GoodsStatus      string `json:"goodsStatus,omitempty"`
	BuyerApplyTextId int    `json:"buyerApplyTextId,omitempty"`
}

type RefundReasonRes struct {
	CommonRes
	Result struct {
		MaxRefundFee            int  `json:"maxRefundFee"`
		MinRefundFee            int  `json:"minRefundFee"`
		MustProof               bool `json:"mustProof"`
		RefundTextWrapperVOList []struct {
			Name        string `json:"name"`
			ReasonGroup int    `json:"reasonGroup"`
			TextId      int    `json:"textId"`
		} `json:"refundTextWrapperVOList"`
	} `json:"result"`
}

//Reason 原因
func (s refund) Reason(ctx context.Context, req RefundReasonReq) (res *RefundReasonRes, err error) {
	method := "tt.refund.refundApplyInit"

	result, err := server.Post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}

type RefundCreateReq struct {
	BizOrderId          string      `json:"bizOrderId"`                    //子订单号
	BizClaimType        string      `json:"bizClaimType"`                  //refund 仅退款 return_and_refund 退货退款
	GoodsStatus         string      `json:"goodsStatus,omitempty"`         //"1"：未收到货 "2"：未已收到货 未发货情况下，千万不要传
	RefundFee           int         `json:"refundFee"`                     //退款金额，单位是分
	ApplyRefundTextId   string      `json:"applyRefundTextId"`             //原因ID
	LeaveMessageContent string      `json:"leaveMessageContent,omitempty"` //退款说明
	LeaveMessagePics    []RefundPic `json:"leaveMessagePics,omitempty"`
}

type RefundCreateRess struct {
	CommonRes
	Result struct {
		DisputeId string `json:"disputeId"`
	} `json:"result"`
}

//Create 申请
func (s refund) Create(ctx context.Context, req RefundCreateReq, image ...string) (res *RefundCreateRess, err error) {
	method := "tt.refund.refundSubmit"
	if len(image) > 0 {
		for _, item := range image {
			req.LeaveMessagePics = append(req.LeaveMessagePics, RefundPic{MessagePic: item})
		}
	}

	result, err := server.Post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}

//Cancel 取消售后
//`bizOrderId` 子订单号
//`disputeId` 售后单号
func (s refund) Cancel(ctx context.Context, bizOrderId, disputeId string) (res *CommonRes, err error) {
	method := "tt.refund.refundRevoke"

	result, err := server.Post(ctx, method, g.Map{
		"request": g.Map{
			"bizOrderId": bizOrderId,
			"disputeId":  disputeId,
		},
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}

type RefundSubmitReq struct {
	DisputeId        string      `json:"disputeId"`
	BizOrderId       string      `json:"bizOrderId"`
	CompanyCode      string      `json:"logisticsCompanyCode"`
	CompanyId        string      `json:"logisticsCompanyId"`
	CompanyName      string      `json:"logisticsCompanyName"`
	LogisticsNo      string      `json:"logisticsNo"`
	MobileNum        string      `json:"mobileNum"`
	LeaveMessagePics []RefundPic `json:"leaveMessagePics"`
}

type RefundSubmitRes struct {
	CommonRes
	Result struct {
		DisputeStatus string `json:"disputeStatus"`
		//REFUND_WAIT_SELLER_AGREE："买家已经申请退款，等待卖家同意"；
		//REFUND_WAIT_BUYER_RETURN_GOODS："卖家已经同意退款，等待买家退货"；
		//REFUND_WAIT_SELLER_CONFIRM_GOODS："买家已经退货，等待卖家确认收货"；
		//REFUND_CLOSED："退款关闭"；
		//REFUND_SUCCESS："退款成功"；
		//REFUND_SELLER_REFUSE_BUYER："卖家拒绝退款"；
		//REFUND_WAIT_BUYER_CONFIRM_REDO_SEND_GOODS："等待买家确认重新邮寄的货物"；
		//REFUND_WAIT_SELLER_CONFIRM_RETURN_ADDRESS："等待卖家确认退货地址"
	} `json:"result"`
}

//Submit 提交物流信息
func (s refund) Submit(ctx context.Context, req RefundSubmitReq, image ...string) (res *CommonRes, err error) {
	method := "tt.refund.submitLogisticInfo.v1"
	if len(image) > 0 {
		for _, item := range image {
			req.LeaveMessagePics = append(req.LeaveMessagePics, RefundPic{MessagePic: item})
		}
	}
	result, err := server.Post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}

type RefundDetailRes struct {
	CommonRes
	Result struct {
		DisputeId     int64  `json:"disputeId"` //退款编号
		DisputeStatus string `json:"disputeStatus"`
		//退款状态
		//REFUND_WAIT_SELLER_AGREE："买家已经申请退款，等待卖家同意"；
		//REFUND_WAIT_BUYER_RETURN_GOODS："卖家已经同意退款，等待买家退货"；
		//REFUND_WAIT_SELLER_CONFIRM_GOODS："买家已经退货，等待卖家确认收货"；
		//REFUND_CLOSED："退款关闭"；
		//REFUND_SUCCESS："退款成功"；
		//REFUND_SELLER_REFUSE_BUYER："卖家拒绝退款"；
		//REFUND_WAIT_BUYER_CONFIRM_REDO_SEND_GOODS："等待买家确认重新邮寄的货物"；
		//REFUND_WAIT_SELLER_CONFIRM_RETURN_ADDRESS："等待卖家确认退货地址"
		DisputeTimeOut struct {
			Duration          int    `json:"duration"`
			GmtCreate         int64  `json:"gmtCreate"`
			Running           bool   `json:"running"`
			TimeoutActionType string `json:"timeoutActionType"`
		} `json:"disputeTimeOut"`
		ReasonName                string `json:"reasonName"` //退款原因名称
		RefundFee                 int    `json:"refundFee"`  //退款金额，单位分
		ShippingAddressWrapperDTO struct {
			AddressDetail     string `json:"addressDetail"`
			AreaName          string `json:"areaName"`
			CityName          string `json:"cityName"`
			ConsigneeFullName string `json:"consigneeFullName"`
			DivisionCode      string `json:"divisionCode"`
			Mobile            string `json:"mobile"`
			PostCode          string `json:"postCode"`
			ProvinceName      string `json:"provinceName"`
			TownName          string `json:"townName"`
		} `json:"shippingAddressWrapperDTO"`
	} `json:"result"`
}

//Detail 详情
func (s refund) Detail(ctx context.Context, bizOrderId, disputeId string) (res *RefundDetailRes, err error) {
	method := "tt.refund.queryRefundDetail"

	result, err := server.Post(ctx, method, g.Map{
		"request": g.Map{
			"bizOrderId": bizOrderId,
			"disputeId":  disputeId,
		},
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}
