package itao

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type auth struct {
}

var Auth = auth{}

type AuthStatusRes struct {
	Code    string `json:"code"`
	Message string `json:"message"`
}

//Status 授权状态
func (s auth) Status(ctx context.Context) (res *AuthStatusRes, err error) {
	method := "tt.authority.checkAuthStatus"

	result, err := server.Get(ctx, method, g.Map{
		"bId": server.AppKey,
	})
	_ = gjson.New(result).Scan(&res)
	return

}

type AuthQrCodeRes struct {
	Code               string `json:"code"`
	Message            string `json:"message"`
	TempCode           string `json:"tempCode"`
	TempCodeExpireTime string `json:"tempCodeExpireTime"`
	QrCodeUrl          string `json:"qrCodeUrl"`
}

//QrCode 二维码
func (s auth) QrCode(ctx context.Context) (res *AuthQrCodeRes, err error) {
	method := "tt.authority.generateQrCode"

	result, err := Get(ctx, method, g.Map{
		"bId": server.AppKey,
	})
	_ = gjson.New(result).Scan(&res)
	return

}

type AuthTokenRes struct {
	Code                   string `json:"code"`
	Message                string `json:"message"`
	RefreshToken           string `json:"refreshToken"`
	AccessToken            string `json:"accessToken"`
	AccessTokenExpireTime  int64  `json:"accessTokenExpireTime"`
	RefreshTokenExpireTime int64  `json:"refreshTokenExpireTime"`
	TaoteId                string `json:"taoteId"`
	TaoteNickName          string `json:"taoteNickName"`
	Feature                string `json:"feature"`
	GwTraceId              string `json:"gw_trace_id"`
}

//Token 授权
func (s auth) Token(ctx context.Context, code string, Type int) (res *AuthTokenRes, err error) {
	method := "tt.auth.getAccessToken"
	var request = g.Map{
		"bId": server.AppKey,
	}
	if Type == 1 {
		request["code"] = code //临时令牌
		request["grantType"] = "code"
	} else {
		request["refreshToken"] = code //刷新令牌
		request["grantType"] = "refreshToken"
	}

	result, err := Get(ctx, method, request)
	_ = gjson.New(result).Scan(&res)
	return
}

//Unbind 注销授权
func (s auth) Unbind(ctx context.Context) (res *AuthTokenRes, err error) {
	method := "tt.authority.unbind"

	result, err := server.Get(ctx, method, g.Map{
		"bId": server.AppKey,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
