package ikc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type refundIkc struct {
}

//Refund 售后
var Refund = refundIkc{}

type RefundCreateReq struct {
	OrderId      string `json:"orderId"`         //二级单号
	DetatilId    string `json:"orderDetatilId"`  //三级订单号
	PicUrls      string `json:"picUrls"`         //图片, 逗号隔开， 最多三张
	Description  string `json:"description"`     //描述(100字内)
	RefundReason string `json:"refundReason"`    //退货原因:	0- 不想要了（无理由）	1- 商品漏发	2-质量问题	3-发错款号	4-发错颜色	5-发错尺码
	Type         string `json:"applicationType"` //服务类型:	2-漏发退款	4-退货退款
	IsReceived   string `json:"isReceived"`      //漏发退款是否收货标识	0-未收货(整件漏发)	1-已收货(部分漏发)
	Amount       string `json:"amount"`          //申请退款金额 单位:元
}

type RefundCreateRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          []struct {
		OrderId       string `json:"orderId"`
		OrderDetailId string `json:"orderDetailId"`
		ApprovalType  int    `json:"approvalType"`
		AuditResult   string `json:"auditResult"`
		AuditType     int    `json:"auditType"`
		ApplyTime     string `json:"applyTime"`
	} `json:"data"`
}

//Create 申请
func (*refundIkc) Create(ctx context.Context, req RefundCreateReq) (res *RefundCreateRes, err error) {
	method := "after-sale/new/create"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type RefundSubmitReq struct {
	ApplicationNo    string `json:"applicationNo"`    //申请编号
	LogisticsCompany string `json:"logisticsCompany"` //物流公司名
	ShipmentNo       string `json:"shipmentNo"`       //物流单号
	ReturnAddress    string `json:"returnAddress"`    //用户收货地址
	ReturnName       string `json:"returnName"`       //退回联系人
	ReturnPhone      string `json:"returnPhone"`      //退回人电话
	LogisticsCode    string `json:"logisticsCode"`    //物流公司code
}
type RefundSubmitRes struct {
	ResultCode int `json:"resultCode"`
	Data       struct {
		ApplicationNo string `json:"applicationNo"`
	} `json:"data"`
}

//Submit 上传快递单
func (*refundIkc) Submit(ctx context.Context, req RefundSubmitReq) (res *RefundSubmitRes, err error) {
	method := "after-sale/new/uploadlogistics"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type RefundDetailRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          struct {
		ApplicationNo                 string   `json:"applicationNo"`
		ApplicationType               string   `json:"applicationType"`
		LogisticsCompany              string   `json:"logisticsCompany"`
		ShipmentNo                    string   `json:"shipmentNo"`
		ReturnAddress                 string   `json:"returnAddress"`
		ReturnName                    string   `json:"returnName"`
		ReturnPhone                   string   `json:"returnPhone"`
		Amount                        string   `json:"amount"`
		Profit                        string   `json:"profit"`
		Freight                       string   `json:"freight"`
		AuditStatus                   string   `json:"auditStatus"`
		FirstAuditTime                string   `json:"firstAuditTime"`
		WarehouseAuditTime            string   `json:"warehouseAuditTime"`
		Style                         string   `json:"style"`
		Barcode                       string   `json:"barcode"`
		Size                          string   `json:"size"`
		Price                         string   `json:"price"`
		ApplicationReasonFirLevel     string   `json:"applicationReasonFirLevel"`
		ApplicationReasonFirLevelName string   `json:"applicationReasonFirLevelName"`
		ProblemDescription            string   `json:"problemDescription"`
		ApplicationTime               string   `json:"applicationTime"`
		ProductPicUrls                []string `json:"productPicUrls"`
		FreightInsuranceInfo          struct {
			ClaimAmount     string `json:"claimAmount"`
			ClaimRemark     string `json:"claimRemark"`
			RefundInsurance bool   `json:"refundInsurance"`
		} `json:"freightInsuranceInfo"`
	} `json:"data"`
}

//Detail 查询售后单
//`applicationNo` 申请单号
func (*refundIkc) Detail(ctx context.Context, applicationNo string) (res *RefundDetailRes, err error) {
	method := "after-sale/new/query"
	result, err := post(ctx, method, g.Map{
		"applicationNo": applicationNo,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

//Cancel 取消
//`applicationNo` 申请单号
//`DetailId` 三级单号
func (*refundIkc) Cancel(ctx context.Context, applicationNo, DetailId string) (res *CommonRes, err error) {
	method := "after-sale/new/cancel"
	result, err := post(ctx, method, g.Map{
		"applicationNo": applicationNo,
		"orderDetailId": DetailId,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type RefundAddressRes struct {
	ResultCode int `json:"resultCode"`
	Data       struct {
		LiveId  string `json:"liveId"`
		Phone   string `json:"phone"`
		Address string `json:"address"`
		Name    string `json:"name"`
		Type    string `json:"type"`
	} `json:"data"`
}

func (*refundIkc) Address(ctx context.Context, liveId string) (res *RefundAddressRes, err error) {
	method := "after-sale/new/queryAfterSaleAdd"
	result, err := post(ctx, method, g.Map{
		"liveId": liveId,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
