package gome

import (
	"context"
	"github.com/gogf/gf/container/garray"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type goodsGome struct {
}

var Goods = goodsGome{}

type GetSkuRes struct {
	*CommonRes
	Data []struct {
		Cat1Id             string `json:"cat1Id"`
		Cat1Name           string `json:"cat1Name"`
		Cat2Id             string `json:"cat2Id"`
		Cat2Name           string `json:"cat2Name"`
		Cat3Id             string `json:"cat3Id"`
		Cat3Name           string `json:"cat3Name"`
		SkuName            string `json:"skuName"`
		SkuShortName       string `json:"skuShortName"`
		BarCode            string `json:"barCode"`
		MchSkuId           string `json:"mchSkuId"`
		SkuWeight          int64  `json:"skuWeight"`
		ItemNo             string `json:"itemNo"`
		OriginalPrice      string `json:"originalPrice"`
		CostPrice          string `json:"costPrice"`
		SellPoint          string `json:"sellPoint"`
		AfterSaleAllowDays int    `json:"afterSaleAllowDays"`
		Valid              int    `json:"valid"`
		SkuImgs            []struct {
			Type int    `json:"type"`
			Url  string `json:"url"`
		} `json:"skuImgs"`
		Props []struct {
			Pname  string `json:"pname"`
			Pvalue string `json:"pvalue"`
		} `json:"props"`
		Attrs []struct {
			Aname  string `json:"aname"`
			Avalue string `json:"avalue"`
		} `json:"attrs"`
	} `json:"data"`
}

type SkuListReq struct {
	PageNo          int    `json:"pageNo"`
	PageSize        int    `json:"pageSize"`
	BeginUpdateTime string `json:"beginUpdateTime,omitempty"`
	EndUpdateTime   string `json:"endUpdateTime,omitempty"`
}

type SkuListRes struct {
	*CommonRes
	Data struct {
		*CommonPageRes
		Result []struct {
			Cat1Id             string `json:"cat1Id"`
			Cat1Name           string `json:"cat1Name"`
			Cat2Id             string `json:"cat2Id"`
			Cat2Name           string `json:"cat2Name"`
			Cat3Id             string `json:"cat3Id"`
			Cat3Name           string `json:"cat3Name"`
			SkuName            string `json:"skuName"`
			SkuShortName       string `json:"skuShortName"`
			BarCode            string `json:"barCode"`
			MchSkuId           string `json:"mchSkuId"`
			SkuWeight          int64  `json:"skuWeight"`
			ItemNo             string `json:"itemNo"`
			OriginalPrice      string `json:"originalPrice"`
			CostPrice          string `json:"costPrice"`
			SellPoint          string `json:"sellPoint"`
			AfterSaleAllowDays int    `json:"afterSaleAllowDays"`
			Valid              int    `json:"valid"`
			SkuImgs            []struct {
				Type int    `json:"type"`
				Url  string `json:"url"`
			} `json:"skuImgs"`
			Props []struct {
				Pname  string `json:"pname"`
				Pvalue string `json:"pvalue"`
			} `json:"props"`
			Attrs []struct {
				Aname  string `json:"aname"`
				Avalue string `json:"avalue"`
			} `json:"attrs"`
		} `json:"result"`
	} `json:"data"`
}

type GetGoodsRes struct {
	*CommonRes
	Data struct {
		SpuName            string   `json:"spuName"`
		MchSpuId           string   `json:"mchSpuId"`
		Cat1Id             string   `json:"cat1Id"`
		Cat1Name           string   `json:"cat1Name"`
		Cat2Id             string   `json:"cat2Id"`
		Cat2Name           string   `json:"cat2Name"`
		Cat3Id             string   `json:"cat3Id"`
		Cat3Name           string   `json:"cat3Name"`
		BrandCode          string   `json:"brandCode"`
		BrandName          string   `json:"brandName"`
		Unit               string   `json:"unit"`
		SpuModel           string   `json:"spuModel"`
		ImportFlag         int      `json:"importFlag"`
		Place              string   `json:"place"`
		Keyword            string   `json:"keyword"`
		Adword             string   `json:"adword"`
		PackingList        string   `json:"packingList"`
		AfterService       string   `json:"afterService"`
		AfterSaleAllowDays int      `json:"afterSaleAllowDays"`
		CreateTime         string   `json:"createTime"`
		CoverImg           string   `json:"coverImg"`
		MainImgs           []string `json:"mainImgs"`
		DetailsImgs        []string `json:"detailsImgs"`
		Skus               []struct {
			Cat1Id             string `json:"cat1Id"`
			Cat1Name           string `json:"cat1Name"`
			Cat2Id             string `json:"cat2Id"`
			Cat2Name           string `json:"cat2Name"`
			Cat3Id             string `json:"cat3Id"`
			Cat3Name           string `json:"cat3Name"`
			SkuName            string `json:"skuName"`
			SkuShortName       string `json:"skuShortName"`
			BarCode            string `json:"barCode"`
			MchSkuId           string `json:"mchSkuId"`
			SkuWeight          int64  `json:"skuWeight"`
			ItemNo             string `json:"itemNo"`
			OriginalPrice      string `json:"originalPrice"`
			CostPrice          string `json:"costPrice"`
			SellPoint          string `json:"sellPoint"`
			AfterSaleAllowDays int    `json:"afterSaleAllowDays"`
			Valid              int    `json:"valid"`
			SkuImgs            []struct {
				Type int    `json:"type"`
				Url  string `json:"url"`
			} `json:"skuImgs"`
			Props []struct {
				Pname  string `json:"pname"`
				Pvalue string `json:"pvalue"`
			} `json:"props"`
			Attrs []struct {
				Aname  string `json:"aname"`
				Avalue string `json:"avalue"`
			} `json:"attrs"`
		} `json:"skus"`
		Props []struct {
			Pname  string `json:"pname"`
			Pvalue string `json:"pvalue"`
		} `json:"props"`
	} `json:"data"`
}

type GoodsListReq struct {
	PageNo          int    `json:"pageNo"`
	PageSize        int    `json:"pageSize"`
	BeginUpdateTime string `json:"beginUpdateTime,omitempty"`
	EndUpdateTime   string `json:"endUpdateTime,omitempty"`
}

type GoodsListRes struct {
	*CommonRes
	Data struct {
		*CommonPageRes
		Result []struct {
			SpuName            string   `json:"spuName"`
			MchSpuId           string   `json:"mchSpuId"`
			Cat1Id             string   `json:"cat1Id"`
			Cat1Name           string   `json:"cat1Name"`
			Cat2Id             string   `json:"cat2Id"`
			Cat2Name           string   `json:"cat2Name"`
			Cat3Id             string   `json:"cat3Id"`
			Cat3Name           string   `json:"cat3Name"`
			BrandCode          string   `json:"brandCode"`
			BrandName          string   `json:"brandName"`
			Unit               string   `json:"unit"`
			SpuModel           string   `json:"spuModel"`
			ImportFlag         int      `json:"importFlag"`
			Place              string   `json:"place"`
			Keyword            string   `json:"keyword"`
			Adword             string   `json:"adword"`
			PackingList        string   `json:"packingList"`
			AfterService       string   `json:"afterService"`
			AfterSaleAllowDays int      `json:"afterSaleAllowDays"`
			CreateTime         string   `json:"createTime"`
			CoverImg           string   `json:"coverImg"`
			MainImgs           []string `json:"mainImgs"`
			DetailsImgs        []string `json:"detailsImgs"`
			Skus               []struct {
				Cat1Id             string `json:"cat1Id"`
				Cat1Name           string `json:"cat1Name"`
				Cat2Id             string `json:"cat2Id"`
				Cat2Name           string `json:"cat2Name"`
				Cat3Id             string `json:"cat3Id"`
				Cat3Name           string `json:"cat3Name"`
				SkuName            string `json:"skuName"`
				SkuShortName       string `json:"skuShortName"`
				BarCode            string `json:"barCode"`
				MchSkuId           string `json:"mchSkuId"`
				SkuWeight          int64  `json:"skuWeight"`
				ItemNo             string `json:"itemNo"`
				OriginalPrice      string `json:"originalPrice"`
				CostPrice          string `json:"costPrice"`
				SellPoint          string `json:"sellPoint"`
				AfterSaleAllowDays int    `json:"afterSaleAllowDays"`
				Valid              int    `json:"valid"`
				SkuImgs            []struct {
					Type int    `json:"type"`
					Url  string `json:"url"`
				} `json:"skuImgs"`
				Props []struct {
					Pname  string `json:"pname"`
					Pvalue string `json:"pvalue"`
				} `json:"props"`
				Attrs []struct {
					Aname  string `json:"aname"`
					Avalue string `json:"avalue"`
				} `json:"attrs"`
			} `json:"skus"`
			Props []struct {
				Pname  string `json:"pname"`
				Pvalue string `json:"pvalue"`
			} `json:"props"`
		} `json:"result"`
	} `json:"data"`
}

type GoodsPriceRes struct {
	*CommonRes
	Data []struct {
		MchSkuId  string `json:"mchSkuId"`
		CostPrice int64  `json:"costPrice"`
	} `json:"data"`
}

//GetSku 单个 SKU 查询
func (goodsGome) GetSku(ctx context.Context, sku interface{}) (res *GetSkuRes, err error) {
	method := "alamein.product.read.querySingleSku"

	req := g.Map{
		"mchSkuId": gconv.String(sku),
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//SkuList 分页 SKU 查询
func (goodsGome) SkuList(ctx context.Context, req *SkuListReq) (res *SkuListRes, err error) {
	method := "alamein.product.read.pageQuerySku"

	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

// GetGoods 单个 SPU 查询
func (goodsGome) GetGoods(ctx context.Context, GoodsID interface{}) (res *GetGoodsRes, err error) {
	method := "alamein.product.read.querySingleSpu"

	var req = g.Map{
		"mchSpuId": gconv.String(GoodsID),
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//GoodsList 分页 SPU 查询
func (goodsGome) GoodsList(ctx context.Context, req *GoodsListReq) (res *GoodsListRes, err error) {
	method := "alamein.product.read.pageQuerySpu"

	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//Price 商品价格批量查询
func (goodsGome) Price(ctx context.Context, sku *garray.Array) (res *GoodsPriceRes, err error) {
	method := "alamein.price.read.querySkuPrice"

	var req = g.Map{
		"mchSkuIds": sku.Slice(),
	}

	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
