package tm

import (
	"context"
	"encoding/json"
	link "github.com/alibabacloud-go/linkedmall-20220531/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"

)

type orderTm struct {
}

var Order = orderTm{}

type OrderAddress struct {
	AddressDetail string `json:"AddressDetail"`
	DivisionCode  string `json:"DivisionCode"`
	FullName      string `json:"FullName"`
	Mobile        string `json:"Mobile"`
	TownDivisionCode string `json:"TownDivisionCode"`
}
type RenderDistributionOrderReq struct {
	ItemInfoLists []*ItemInfo `json:"ItemInfoLists"`
	BuyerId string `json:"BuyerId"`
	Addr string `json:"Addr"`
}
type ItemInfo struct{
	DistributionMallId string `json:"DistributionMallId,omitempty" xml:"DistributionMallId,omitempty"`
	LmItemId           string `json:"LmItemId,omitempty" xml:"LmItemId,omitempty"`
	Quantity           int32  `json:"Quantity,omitempty" xml:"Quantity,omitempty"`
	SkuId              string `json:"SkuId,omitempty" xml:"SkuId,omitempty"`
}
type RenderDistributionOrderRes struct {
	Code    string `json:" Code"`
	Message string `json:"Message"`
	Model   struct {
		AddressInfos []struct {
			AddressDetail    string `json:"AddressDetail"`
			AddressId        int64  `json:"AddressId"`
			DivisionCode     string `json:"DivisionCode"`
			Receiver         string `json:"Receiver"`
			ReceiveRPhone    string `json:"Receive rPhone"`
			TownDivisionCode string `json:"TownDivisionCode"`
		} `json:"AddressInfos"`
		CanSell          bool `json:"CanSell"`
		RenderOrderInfos []struct {
			CanSell       bool `json:"CanSell"`
			DeliveryInfos []struct {
				DisplayName string `json:"DisplayName"`
				Id          string `json:"Id"`
				PostFee     int    `json:"PostFee"`
				ServiceType int    `json:"ServiceType"`
			} `json:"DeliveryInfos"`
			InvoiceInfo struct {
			} `json:"InvoiceInfo"`
			ItemInfos []struct {
				CanSell            bool   `json:"CanSell"`
				DistributionMallId string `json:"DistributionMallId"`
				Features           struct {
					DeliveryVersion string `json:"delivery_version"`
					ExTraPeriod     string `json:"ex traPeriod"`
					TaxInvoice      string `json:"tax_invoice"`
				} `json:"Features"`
				ItemId     string `json:"ItemId"`
				ItemName   string `json:"ItemName"`
				ItemPicUrl string `json:"ItemPicUrl"`
				Price      int    `json:"Price"`
				Quantity   int    `json:"Quantity"`
				SkuId      int64  `json:"SkuId"`
				SkuName    string `json:"SkuName"`
			} `json:"ItemInfos"`
		} `json:"RenderOrderInfos"`
		UnsellableRenderOrderInfos []struct {
			ItemInfos []struct {
				ItemPicUrl string `json:"ItemPicUrl"`
				Message    string `json:"Message"`
				Price      int    `json:"Price"`
				ItemName   string `json:"ItemName"`
				Quantity   int    `json:"Quantity"`
				Features   struct {
					DeliveryVersion string `json:"delivery_version"`
				} `json:"Features"`
				SkuId              int    `json:"SkuId"`
				ItemId             string `json:"ItemId"`
				DistributionMallId string `json:"DistributionMallId"`
				CanSell            bool   `json:"CanSell"`
			} `json:"ItemInfos"`
			CanSell bool `json:"CanSell"`
		} `json:"UnsellableRenderOrderInfos"`
	} `json:"Model"`
	RequestId string `json:"RequestId"`
	Success   bool   `json:"Success"`
}

type OrderCreateReq struct {
	UserId       string
	ChannelOrder string
	Address      string
	ItemLists    []OrderGoodsItem
}
type OrderGoodsItem struct {
	LmItemId   string `json:"LmItemId"`
	Quantity string `json:"Quantity"`
	SkuId    string `json:"SkuId"`
	DistributionMallId string `json:"DistributionMallId"`

}
type OrderCreateRes struct {
	RequestId string `json:"RequestId"`
	Message   string `json:"Message"`
	Model     string `json:"Model"`
	Code      string `json:"Code"`
	Success   bool   `json:"Success"`
}
type OrderFilter struct {
	DistributionTradeId     string `json:"DistributionTradeId,omitempty"`
	OrderList    []string `json:"OrderList,omitempty"`
	LogisticsStatus string   `json:"LogisticsStatus,omitempty"`
	OrderStatus     string   `json:"OrderStatus,omitempty"`
}
type T struct {
	CreateDate          string `json:"createDate"`
	DistributionOrderId string `json:"distributionOrderId"`
	DistributorId       string `json:"distributorId"`
	LogisticsStatus     string `json:"logisticsStatus"`
	OrderAmount         string `json:"orderAmount"`
	OrderStatus         string `json:"orderStatus"`
	SubOrderList        []struct {
		ItemId    string `json:"itemId"`
		ItemPic   string `json:"itemPic"`
		ItemPrice []struct {
			FundAmountMoney string `json:"fundAmountMoney"`
		} `json:"itemPrice"`
		ItemTitle               string `json:"itemTitle"`
		Number                  string `json:"number"`
		SkuId                   string `json:"skuId"`
		SkuName                 string `json:"skuName"`
		OrderStatus             string `json:"orderStatus"`
		LogisticsStatus         string `json:"logisticsStatus"`
		SubDistributionOrderId  string `json:"subDistributionOrderId"`
		MainDistributionOrderId string `json:"mainDistributionOrderId"`
	} `json:"subOrderList"`
}
type OrderListRes struct {
	RequestId   string `json:"RequestId"`
	Message     string `json:"Message"`
	PageSize    int    `json:"PageSize"`
	PageNumber  int    `json:"PageNumber"`
	Code string `json:"Code"`
	Model []struct{
		CreateDate          string `json:"CreateDate"`
		DistributionOrderId string `json:"DistributionOrderId"`
		DistributorId       string `json:"DistributorId"`
		LogisticsStatus     string `json:"LogisticsStatus"`
		OrderAmount         string `json:"OrderAmount"`
		OrderStatus         string `json:"OrderStatus"`
		SubOrderList        []struct {
			ItemId    string `json:"ItemId"`
			ItemPic   string `json:"ItemPic"`
			ItemPrice []struct {
				FundAmountMoney string `json:"FundAmountMoney"`
			} `json:"ItemPrice"`
			ItemTitle               string `json:"ItemTitle"`
			Number                  string `json:"Number"`
			SkuId                   string `json:"SkuId"`
			SkuName                 string `json:"SkuName"`
			OrderStatus             string `json:"OrderStatus"`
			LogisticsStatus         string `json:"LogisticsStatus"`
			SubDistributionOrderId  string `json:"SubDistributionOrderId"`
			MainDistributionOrderId string `json:"MainDistributionOrderId"`
		} `json:"SubOrderList"`
	}
}

type OrderListReq struct {
	DistributorId       string `json:"DistributorId"`
	FilterOption        struct{
		DistributionTradeId string `json:"DistributionTradeId"`
		OrderList       []string `json:"OrderList"`
	}   `json:"FilterOption"`
	PageNumber       int32 `json:"PageNumber"`
	PageSize int32 `json:"PageSize"`
	LogisticsStatus string `json:"LogisticsStatus"`
	OrderStatus     string `json:"OrderStatus"`

}
type FilterOption struct {

}
type OrderInfoReq struct {
	MainDistributionOrderId       string `json:"MainDistributionOrderId"`
	UserId          string `json:"UserId"`
	LmOrderId       string `json:"LmOrderId"`
	LogisticsStatus string `json:"LogisticsStatus"`
	OrderStatus     string `json:"OrderStatus"`
}
type OrderInfoRes struct {
	RequestId   string `json:"RequestId"`
	Message     string `json:"Message"`
	Code string `json:"Code"`
	Model struct{
		CreateDate          string `json:"CreateDate"`
		DistributionOrderId string `json:"DistributionOrderId"`
		DistributorId       string `json:"DistributorId"`
		LogisticsStatus     string `json:"LogisticsStatus"`
		OrderAmount         string `json:"OrderAmount"`
		OrderStatus         string `json:"OrderStatus"`
		SubOrderList        []struct {
			ItemId    string `json:"ItemId"`
			ItemPic   string `json:"ItemPic"`
			ItemPrice []struct {
				FundAmountMoney string `json:"FundAmountMoney"`
			} `json:"ItemPrice"`
			ItemTitle               string `json:"ItemTitle"`
			Number                  string `json:"Number"`
			SkuId                   string `json:"SkuId"`
			SkuName                 string `json:"SkuName"`
			OrderStatus             string `json:"OrderStatus"`
			LogisticsStatus         string `json:"LogisticsStatus"`
			SubDistributionOrderId  string `json:"SubDistributionOrderId"`
			MainDistributionOrderId string `json:"MainDistributionOrderId"`
		} `json:"SubOrderList"`
	} `json:"Model"`
}
type OrderStatusReq struct {
	DistributionTradeId string `json:"DistributionTradeId"`
}
type OrderStatusRes struct {
	RequestId   string `json:"RequestId"`
	Message     string `json:"Message"`
	Code string `json:"Code"`
	Model string `json:"Model"`
	//1：分销单创建中
	//
	//10：采购中
	//
	//20：采购成功，待发货
	//
	//21：采购成功，部分发货
	//
	//22：采购成功，全部发货
	//
	//30：部分采购成功，待发货
	//
	//31：部分采购成功，部分发货
	//
	//32：部分采购成功，全部发货
	//
	//80：交易失败
	//
	//81：采购失败
	//
	//99：交易成功
}
type AddrInfoReq struct {
	DivisionCode          string `json:"DivisionCode"`
}
type AddrInfoRes struct {
	RequestId   string `json:"RequestId"`
	Message     string `json:"Message"`
	Code string `json:"Code"`
	Model struct{
	DivisionList []AddrInfo `json:"DivisionList"`
	} `json:"Model"`
}
type AddrInfo struct {
	ParentId      int    `json:"ParentId"`
	DivisionLevel int    `json:"DivisionLevel"`
	DivisionName  string `json:"DivisionName"`
	Pinyin        string `json:"Pinyin"`
	DivisionCode  int    `json:"DivisionCode"`
}
//Before 验证订单商品
func (s *orderTm) Before(ctx context.Context,itemInfo *RenderDistributionOrderReq) (res *RenderDistributionOrderRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}
	if itemInfo==nil{
		return
	}
	var itemInfoLists []*link.RenderDistributionOrderRequestItemInfoLists
	err =gjson.New(itemInfo.ItemInfoLists).Scan(&itemInfoLists)
	result ,err :=client.RenderDistributionOrder(&link.RenderDistributionOrderRequest{
		BuyerId: tea.String(itemInfo.BuyerId),
		DistributorId:      tea.String(server.DistributorId),
		ItemInfoLists:          itemInfoLists,
		TenantId:           tea.String(server.TenantId),
		DeliveryAddress: tea.String(itemInfo.Addr),
      	DistributionSupplierId: tea.String(server.DistributionSupplierId),
	})

	if result==nil{
		return
	}

	log(ctx,gjson.New(itemInfo).MustToJsonString(),result.Body,err)

	a,_ :=json.Marshal(result.Body)
	if err = json.Unmarshal([]byte(a), &res); err != nil {
		return
	}

	return
}

//订单列表
func (s *orderTm) List(ctx context.Context,item *OrderListReq) (res *OrderListRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}

	result ,err :=client.QueryOrderList4Distribution(&link.QueryOrderList4DistributionRequest{
		DistributorId: tea.String(server.DistributorId),
		FilterOption:  tea.String(gjson.New(item.FilterOption).MustToJsonString()),
		PageNumber:    tea.Int32(item.PageNumber),
		PageSize:      tea.Int32(item.PageSize),
		TenantId:      tea.String(server.TenantId),
	})


	if result==nil{
		return
	}
	log(ctx,gjson.New(item).MustToJsonString(),result.Body,err)

	a,_ :=json.Marshal(result.Body)
	if err = json.Unmarshal([]byte(a), &res); err != nil {
		panic(err)
	}
	return
}
//创建订单
func (s *orderTm) Create(ctx context.Context,item *OrderCreateReq) (res *OrderCreateRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}
	if item==nil{
		return
	}
	var itemInfoLists []*link.ApplyCreateDistributionOrderRequestItemInfoLists
	err =gjson.New(item.ItemLists).Scan(&itemInfoLists)

	result ,err :=client.ApplyCreateDistributionOrder(&link.ApplyCreateDistributionOrderRequest{
		DistributorId: tea.String(server.DistributorId),
		TenantId:      tea.String(server.TenantId),
		DistributionSupplierId:      tea.String(server.DistributionSupplierId),
		BuyerId:      tea.String(item.UserId),
		ItemInfoLists:      itemInfoLists,
		DeliveryAddress:      tea.String(item.Address),
	})

	if result==nil{
		return
	}
	log(ctx,gjson.New(item).MustToJsonString(),result.Body,err)

	a,_ :=json.Marshal(result.Body)
	if err = json.Unmarshal([]byte(a), &res); err != nil {
		return
	}

	return
}
//订单详情
func (s *orderTm) Detail(ctx context.Context,item *OrderInfoReq) (res *OrderInfoRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}
	result ,err :=client.QueryOrderDetail4Distribution(&link.QueryOrderDetail4DistributionRequest{
		DistributorId: tea.String(server.DistributorId),
		MainDistributionOrderId: tea.String(item.MainDistributionOrderId),
		TenantId:      tea.String(server.TenantId),
	})

	if result==nil{
		return
	}
	log(ctx,gjson.New(item).MustToJsonString(),result.Body,err)

	a,_ :=json.Marshal(result.Body)
	if err = json.Unmarshal([]byte(a), &res); err != nil {
		panic(err)
	}

	return
}
//订单交易状态
func (s *orderTm) Status(ctx context.Context,item *OrderStatusReq) (res *OrderStatusRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}
	result ,err :=client.QueryDistributionTradeStatus(&link.QueryDistributionTradeStatusRequest{
		DistributorId: tea.String(server.DistributorId),
		DistributionTradeId: tea.String(item.DistributionTradeId),
		TenantId:      tea.String(server.TenantId),
		DistributionSupplierId: tea.String(server.DistributionSupplierId),
	})

	if result==nil{
		return
	}
	log(ctx,gjson.New(item).MustToJsonString(),result.Body,err)

	a,_ :=json.Marshal(result.Body)
	if err = json.Unmarshal([]byte(a), &res); err != nil {
		panic(err)
	}


	return
}
//地址
func (s *orderTm) AddrInfo(ctx context.Context,itemInfo *AddrInfoReq) (res *AddrInfoRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}

	result ,err :=client.QueryChildDivisionCodeById(&link.QueryChildDivisionCodeByIdRequest{
		DistributorId:      tea.String(server.DistributorId),
		DivisionCode:         tea.String(itemInfo.DivisionCode),
		TenantId:           tea.String(server.TenantId),
	})

	if result==nil{
		return
	}
	log(ctx,gjson.New(itemInfo).MustToJsonString(),result.Body,err)

	a,_ :=json.Marshal(result.Body)
	if err = json.Unmarshal([]byte(a), &res); err != nil {
		panic(err)
	}

	return
}
//订单详情
//func (s *orderTm) Detail(ctx context.Context,req OrderInfoReq) (res OrderInfoRes,err error) {
//
//	method := "QueryOrderDetail4Distribution"
//
//
//	request := map[string]string{
//		"DistributorId" : server.DistributorId,
//		"MainDistributionOrderId" :req.MainDistributionOrderId,
//	}
//
//	result, err := post(ctx, method, request)
//	g.Dump(result,"resuelet--------")
//	//_ = json.Unmarshal([]byte(result), &res)
//	return
//}
//Before 验证订单商品 todo 该接口正确通过，由于订单部分接口不通过天猫技术不支持对接，后续有时间再自己写
//func (s *orderTm) RenderDistributionOrder(ctx context.Context, addr OrderAddress, itemInfo *RenderDistributionOrderReq) (res *RenderDistributionOrderRes, err error) {
//	method := "RenderDistributionOrder"
//	fmt.Println(1)
//	request := g.MapStrStr{
//		//"ItemInfoLists" :gjson.New(itemInfo.ItemInfoLists).MustToJsonString(),
//		//		"ItemInfoLists":fmt.Sprintf(`{
//		// "lmItemId" : "10027642-706637605402",
//		// "distributionMallId":"9e7b3e4ba5e24dd49b89498f09d05cf1",
//		// "skuId" : "46059969",
//		// "quantity": 1
//		//}`),
//		"DeliveryAddress":        gjson.New(addr).MustToJsonString(),
//		"BuyerId":                itemInfo.BuyerId,
//		"TenantId":               server.TenantId,
//		"DistributorId":          server.DistributorId,
//		"DistributionSupplierId": server.DistributionSupplierId,
//	}
//	g.Dump("request=====", request)
//
//	result, err := post(ctx, method, request)
//	err = gjson.New(result).Scan(&res)
//	return
//}
//Create 下单接口
//func (s *orderTm) Create(ctx context.Context, req OrderCreateReq) (res *OrderCreateRes, err error) {
//	method := "ApplyCreateDistributionOrder"
//	g.Dump("req.ItemLists=====",req.ItemLists)
//	request := convert("ItemInfoLists", gconv.Maps(req.ItemLists))
//	request["DeliveryAddress"] = gjson.New(req.Address).MustToJsonString()
//	request["TenantId"] = server.TenantId
//	request["DistributorId"] = server.DistributorId
//	request["BuyerId"] = req.UserId
//	request["DistributionSupplierId"] = server.DistributionSupplierId
//	request["DistributionOutTradeId"] = req.ChannelOrder
//	result, err := post(ctx, method, request)
//	err =gjson.New(result).Scan(&res)
//	return
//}



//
//type OrderListReq struct {
//	UserId          string
//	ChannelOrder    string
//	LmOrderId       string
//	LogisticsStatus string
//	OrderStatus     string
//}
//


//List 列表
//func (s *orderTm) QueryOrderList4Distribution(ctx context.Context,req OrderListReq) (res OrderListRes,err error) {
//	method := "QueryOrderList4Distribution"
//
//	var filterOption = OrderFilter{
//		LogisticsStatus: "1",
//		OrderStatus:     req.OrderStatus,
//	}
//	//if req.LmOrderId != "" {
//	//	filterOption.LmOrderList = garray.NewStrArray().Append(req.LmOrderId).Slice()
//	//}
//	//if req.ChannelOrder != "" {
//	//	filterOption.ChannelOrder = garray.NewStrArray().Append(req.ChannelOrder).Slice()
//	//
//	//}
//
//	request := map[string]string{
//		"FilterOption":     gjson.New(filterOption).MustToJsonString(),
//		"PageNumber":       "1",
//		"PageSize":         "20",
//		"DistributorId" : server.DistributorId,
//		"TenantId" :server.TenantId,
//
//	}
//
//	result, err := post(ctx, method, request)
//	g.Dump(result,"resuelet--------")
//	//_ = json.Unmarshal([]byte(result), &res)
//	return
//}

//type OrderCancelReq struct {
//	UserId    string
//	LmOrderId string
//}
//

