package tm

import (
	"context"
	link "github.com/alibabacloud-go/linkedmall-20220531/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
)

type goodsTmNew struct {
}

var Goods = goodsTmNew{}

//type QueryItemDetailWithDivisionReq struct {
//	ItemId    string   `json:"ItemId"`
//	//SkuIdList []string `json:"SkuIdList"`
//}
type QueryItemDetailWithDivisionRes struct {
	Code    string `json:"Code"`
	Message string `json:"Message"`
	Model   struct {
		CanSell            bool   `json:"CanSell"`
		CategoryID         int    `json:"CategoryId"`
		CategoryIds        []int  `json:"CategoryIds"`
		City               string `json:"City"`
		Current            string `json:"Current"`
		DescOption         string `json:"DescOption"`
		DescPath           string `json:"DescPath"`
		DistributionMallID string `json:"DistributionMallId"`
		Features           struct {
			DeliveryVersion string `json:"delivery_version"`
			ExtraPeriod     string `json:"extraPeriod"`
			FoodProDate     string `json:"food_pro_date"`
		} `json:"Features"`
		FirstPicURL  string `json:"FirstPicUrl"`
		HasQuantity  bool   `json:"HasQuantity"`
		IforestProps []struct {
			Key   string `json:"key"`
			Value string `json:"value"`
		} `json:"IforestProps"`
		ItemID               int64    `json:"ItemId"`
		ItemImages           []string `json:"ItemImages"`
		ItemTitle            string   `json:"ItemTitle"`
		ItemTotalSimpleValue string   `json:"ItemTotalSimpleValue"`
		ItemTotalValue       int      `json:"ItemTotalValue"`
		LmItemCategory       string   `json:"LmItemCategory"`
		LmItemID             string   `json:"LmItemId"`
		MainPicURL           string   `json:"MainPicUrl"`
		MinPrice             int      `json:"MinPrice"`
		Properties          map[string][]string `json:"Properties"`
		Prov                string `json:"Prov"`
		Quantity            int    `json:"Quantity"`
		ReservePrice        int    `json:"ReservePrice"`
		SecuredTransactions int    `json:"SecuredTransactions"`
		SellerPayPostfee    bool   `json:"SellerPayPostfee"`
		SimpleQuantity      string `json:"SimpleQuantity"`
		SkuModels           []struct {
			DistributionMallID  string `json:"DistributionMallId"`
			ExtJSON             string `json:"ExtJson"`
			HasQuantity         bool   `json:"HasQuantity"`
			ItemID              int64  `json:"ItemId"`
			LmItemID            string `json:"LmItemId"`
			PriceCent           int    `json:"PriceCent"`
			Quantity            int    `json:"Quantity"`
			ReservePrice        int    `json:"ReservePrice"`
			SimpleQuantity      string `json:"SimpleQuantity"`
			SkuID               int64  `json:"SkuId"`
			SkuPicURL           string `json:"SkuPicUrl"`
			SkuPvs              string `json:"SkuPvs"`
			SkuTitle            string `json:"SkuTitle"`
			Status              int    `json:"Status"`
			SupplierPrice       int    `json:"SupplierPrice"`
			CanNotBeSoldCode    string `json:"CanNotBeSoldCode,omitempty"`
			CanNotBeSoldMassage string `json:"CanNotBeSoldMassage,omitempty"`
		} `json:"SkuModels"`
		SkuPropertys []struct {
			ID     int    `json:"Id"`
			Text   string `json:"Text"`
			Values []struct {
				ID   int64  `json:"Id"`
				Text string `json:"Text"`
			} `json:"Values"`
		} `json:"SkuPropertys"`
		UserType int `json:"UserType"`
	} `json:"Model"`
	RequestID string `json:"RequestId"`
	Success   bool   `json:"Success"`
	}

type ListDistributionItemReq struct {
	Page string `json:"page"`
	Limit string `json:"limit"`
	LmItemId string `json:"LmItemId"`
}
type ListDistributionItemRes struct {
		Code    string `json:"Code"`
		Message string `json:"Message"`
		Model   []struct {
			CategoryID         int    `json:"CategoryId"`
			CategoryIds        []int  `json:"CategoryIds"`
			City               string `json:"City"`
			Current            string `json:"Current"`
			DescPath           string `json:"DescPath"`
			DistributionMallID string `json:"DistributionMallId"`
			Features           struct {
				DeliveryVersion string `json:"delivery_version"`
				TaxInvoice      string `json:"tax_invoice"`
				TaxRateCode     string `json:"tax_rate_code"`
			} `json:"Features"`
			FirstPicURL  string `json:"FirstPicUrl"`
			HasQuantity  bool   `json:"HasQuantity"`
			IforestProps []struct {
				Key   string `json:"key"`
				Value string `json:"value"`
			} `json:"IforestProps"`
			IsCanSell            bool     `json:"IsCanSell"`
			IsSellerPayPostfee   bool     `json:"IsSellerPayPostfee"`
			ItemID               int64    `json:"ItemId"`
			ItemImages           []string `json:"ItemImages"`
			ItemTitle            string   `json:"ItemTitle"`
			ItemTotalSimpleValue string   `json:"ItemTotalSimpleValue"`
			ItemTotalValue       int      `json:"ItemTotalValue"`
			LmItemAttributeMap   struct {
				TaxInvoice  string `json:"taxInvoice"`
				TaxRateCode string `json:"taxRateCode"`
			} `json:"LmItemAttributeMap"`
			LmItemCategory string `json:"LmItemCategory"`
			LmItemID       string `json:"LmItemId"`
			MainPicURL     string `json:"MainPicUrl"`
			Properties    map[string][]string `json:"Properties"`
			Prov                string `json:"Prov"`
			Quantity            int    `json:"Quantity"`
			ReservedPrice       int    `json:"ReservedPrice"`
			SecuredTransactions int    `json:"SecuredTransactions"`
			SimpleQuantity      string `json:"SimpleQuantity"`
			SkuModels           []struct {
				DistributionMallID string `json:"DistributionMallId"`
				HasQuantity        bool   `json:"HasQuantity"`
				ItemID             int64  `json:"ItemId"`
				LmItemID           string `json:"LmItemId"`
				LmSkuAttributeMap  struct {
					TaxInvoice  string `json:"taxInvoice"`
					TaxRateCode string `json:"taxRateCode"`
				} `json:"LmSkuAttributeMap"`
				PriceCent      int    `json:"PriceCent"`
				Quantity       int    `json:"Quantity"`
				ReservedPrice  int    `json:"ReservedPrice"`
				SimpleQuantity string `json:"SimpleQuantity"`
				SkuID          int    `json:"SkuId"`
				SkuPicURL      string `json:"SkuPicUrl"`
				SkuPvs         string `json:"SkuPvs"`
				Status         int    `json:"Status"`
				SupplierPrice  int    `json:"SupplierPrice"`
			} `json:"SkuModels"`
			UserType    int    `json:"UserType"`
			VideoPicURL string `json:"VideoPicUrl"`
			VideoURL    string `json:"VideoUrl"`
		} `json:"Model"`
		PageNumber int    `json:"PageNumber"`
		PageSize   int    `json:"PageSize"`
		RequestID  string `json:"RequestId"`
		Success    bool   `json:"Success"`
		TotalCount int    `json:"TotalCount"`
}
//区域库存商品详情
func (s *goodsTmNew) QueryItemDetailWithDivision(ctx context.Context,item string) (res *QueryItemDetailWithDivisionRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}
	result ,err :=client.QueryItemDetailWithDivision(&link.QueryItemDetailWithDivisionRequest{
		DistributionMallId: tea.String(server.DistributionMallId),
		DistributorId:      tea.String(server.DistributorId),
		LmItemId:           tea.String(item),
		TenantId:           tea.String(server.TenantId),
	})
	if result==nil{
		return
	}

	log(ctx,gjson.New(item).MustToJsonString(),result.Body,err)

	_ = gjson.NewWithOptions(result.Body, gjson.Options{
		StrNumber: true,
	}).Scan(&res)

	return
}
////商品列表
func (s *goodsTmNew) ListDistributionItem(ctx context.Context,item *ListDistributionItemReq) (res *ListDistributionItemRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}
	result ,err :=client.ListDistributionItemWithoutCache(&link.ListDistributionItemWithoutCacheRequest{
		DistributionMallId: tea.String(server.DistributionMallId),
		DistributorId:      tea.String(server.DistributorId),
		//LmItemId:           tea.String(item),
		TenantId:           tea.String(server.TenantId),
		PageNumber: tea.Int32(1),
		PageSize: tea.Int32(10),
	})

	if result==nil{
		return
	}
	log(ctx,gjson.New(item).MustToJsonString(),result.Body,err)

	_ = gjson.NewWithOptions(result.Body, gjson.Options{
		StrNumber: true,
	}).Scan(&res)

	return
}
//Detail 详情 todo 该接口正确通过，由于订单部分接口不通过天猫技术不支持对接，后续有时间再自己写
//func (*goodsTmNew) QueryItemDetailWithDivision(ctx context.Context, req string) (res *QueryItemDetailWithDivisionRes, err error) {
//	method := "QueryItemDetailWithDivision"
//	request := g.MapStrStr{
//		"DistributionMallId": server.DistributionMallId,
//		"DistributorId":      server.DistributorId,
//		"LmItemId":           req,
//		"TenantId":           server.TenantId,
//	}
//	result, err := post(ctx, method, request)
//
//	_ = gjson.NewWithOptions(result, gjson.Options{
//				StrNumber: true,
//			}).Scan(&res)
//	return
//}

//todo 部分接口验签通过， 该接口正确通过，由于订单部分接口不通过天猫技术不支持对接，后续有时间再自己写
//func (*goodsTmNew) ListDistributionItem(ctx context.Context, req *ListDistributionItemReq) (res *ListDistributionItemRes, err error) {
//	method := "ListDistributionItem"
//	request := g.MapStrStr{
//				"DistributionMallId": server.DistributionMallId,
//				"DistributorId":      server.DistributorId,
//				//"LmItemId":           req.LmItemId,
//				"TenantId":           server.TenantId,
//				"PageNumber": req.Page,
//				"PageSize": req.Limit,
//	}
//	result, err := post(ctx, method, request)
//	_ = gjson.NewWithOptions(result, gjson.Options{
//		StrNumber: true,
//	}).Scan(&res)
//	return
//}