package wpc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type goodsWpc struct {
}

var Goods = goodsWpc{}

type GoodsListReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	Page       string `json:"page"`
	PageSize   string `json:"pageSize"`
	AreaId     string `json:"areaId,omitempty"`
	AdId       string `json:"adId"`
	GoodsIds   string `json:"goodsIds,omitempty"`
}

type GoodsListRes struct {
	ReturnCode    string `json:"returnCode"`
	ReturnMessage string `json:"returnMessage"`
}

//List 列表
func (*goodsWpc) List(ctx context.Context, req GoodsListReq) (res *GoodsListRes, err error) {
	method := "getGoodsList"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsStockReq struct {
	ChannelId   string `json:"vopChannelId"`
	UserNumber  string `json:"userNumber"`
	GoodFullIds string `json:"goodFullIds,omitempty"`
	AreaId      string `json:"areaId,omitempty"`
}

type GoodsStockRes struct {
	ReturnCode    string `json:"returnCode"`
	ReturnMessage string `json:"returnMessage"`
	Result        struct {
		GoodsStockList struct {
			GoodFullId string `json:"goodFullId"`
			sizes      []struct {
				SizeId      string `json:"sizeId"`
				SizeName    string `json:"sizeName"`
				Stock       int    `json:"stock"`
				Type        int    `json:"type"`
				StockStatus int    `json:"stockStatus"`
			}
		}
	} `json:"result"`
}

//Stock 库存
func (*goodsWpc) Stock(ctx context.Context, req GoodsStockReq) (res *GoodsStockRes, err error) {
	method := "getGoodsStock"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsDetailReq struct {
	ChannelId   string `json:"vopChannelId"`
	UserNumber  string `json:"userNumber"`
	AreaId      string `json:"areaId,omitempty"`
	GoodFullIds string `json:"goodFullIds"`
}

type GoodsDetailRes struct {
	ReturnCode    string `json:"returnCode"`
	ReturnMessage string `json:"returnMessage"`
	Result        struct {
	} `json:"result"`
}

//Detail 详情
func (*goodsWpc) Detail(ctx context.Context, req GoodsDetailReq) (res *GoodsDetailRes, err error) {
	method := "getGoodsDetail"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsStatusReq struct {
	ChannelId   string `json:"vopChannelId"`
	UserNumber  string `json:"userNumber"`
	AreaId      string `json:"areaId,omitempty"`
	GoodFullIds string `json:"goodFullIds"`
}

type GoodsStatusRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        interface{} `json:"result"`
}

//Status 批量查询商品状态
func (*goodsWpc) Status(ctx context.Context, req GoodsStatusReq) (res *GoodsStatusRes, err error) {
	method := "getGoodsStatus"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsSizeStatusReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	AreaId     string `json:"areaId,omitempty"`
	SizeIds    string `json:"sizeIds"`
}

type GoodsSizeStatusRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        interface{} `json:"result"`
}

//SizeStatus 批量查询尺码状态
func (*goodsWpc) SizeStatus(ctx context.Context, req GoodsSizeStatusReq) (res *GoodsSizeStatusRes, err error) {
	method := "getSizeStatus"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsOnlineReq struct {
	ChannelId   string `json:"vopChannelId"`
	UserNumber  string `json:"userNumber"`
	AreaId      string `json:"areaId,omitempty"`
	GoodFullIds string `json:"goodFullIds"`
}

type GoodsOnlineRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        interface{} `json:"result"`
}

//Online 批量查询商品上下架
func (*goodsWpc) Online(ctx context.Context, req GoodsOnlineReq) (res *GoodsOnlineRes, err error) {
	method := "getGoodsOnline"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
