package wpc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type brandWpc struct {
}

var Brand = brandWpc{}

type BrandListReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	Page       string `json:"page"`
	PageSize   string `json:"pageSize"`
	AreaId     string `json:"areaId,omitempty"`
	AdIds      string `json:"adIds,omitempty"`
}

type BrandListRes struct {
}

//List 列表
func (*brandWpc) List(ctx context.Context, req BrandListReq) (res *BrandListRes, err error) {
	method := "getBrandList"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type BrandPreListReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	Page       string `json:"page"`
	PageSize   string `json:"pageSize"`
	AreaId     string `json:"areaId,omitempty"`
	AdIds      string `json:"adIds,omitempty"`
}

type BrandPreListRes struct {
	ReturnCode string `json:"returnCode"`
	Result     struct {
		PageTotal int `json:"pageTotal"`
		PageIndex int `json:"pageIndex"`
		TotalNum  int `json:"totalNum"`
		PageSize  int `json:"pageSize"`
		BrandList []struct {
			AdId            string
			BrandName       string
			BrandImage      string
			SellTimeFrom    string
			SellTimeTo      string
			BrandDesc       string
			CommissionRatio string
			PreTime         string
			Ext1            string
			Ext2            g.MapStrStr
			Notice          string
			Goods           []struct {
				GoodId          string
				GoodImage       string
				BrandCnName     string
				BrandEnName     string
				Logo            string
				Sn              string
				Color           string
				Material        string
				CatNameOne      string
				CatNameTwo      string
				CatNameThree    string
				GoodFullId      string
				GoodOnline      int
				VendorProductId int64
				IsMp            bool
				CatIdOne        string
				CatIdTwo        string
				CatIdThree      string
				VendorSn        string
				GoodsBrandId    string
				SizeTableJson   []string
				DcImageURLs     []string
				Sizes           []struct {
					SizeName        string
					VipshopPrice    string
					MarketPrice     string
					Stock           bool
					SizeId          int64
					BuyMinNum       string
					BuyMaxNum       string
					Commission      string
					SuggestAddPrice string
					SuggestPrice    string
					SkuId           int64
					LimitBuyFlag    bool
				}
			}
			StoreQualificationImgList []struct {
				QualificationType string
				ImgUrl            string
				LicenseNumber     string
			}
			AdCategoryList []struct {
				CateId   int64
				CateName string
			}
			CouponList []struct {
				CouponName        string
				CouponDesc        string
				ActivateBeginTime string
				ActivateEndTime   string
				SurplusSecond     int64
				UseSurplusSecond  int64
				Fav               string
				CouponNo          string
				UseBeginTime      string
				UseEndTime        string
				ShareFav          string
				Buy               string
				Status            int
				ShareType         int
				Type              int
			}
		} `json:"brandList"`
	} `json:"result"`
}

//PreList 预告品牌列表
func (*brandWpc) PreList(ctx context.Context, req BrandPreListReq) (res *BrandPreListRes, err error) {
	method := "getPreBrandList"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
