package tm

import (
	"context"
	"encoding/json"
)

type deliverTm struct {
}

var Deliver = deliverTm{}

type DeliverInfoRes struct {
	Code      string `json:"Code"`
	Message   string `json:"Message"`
	RequestId string `json:"RequestId"`
	Data      struct {
		Data []struct {
			DataProvider        string `json:"DataProvider"`
			LogisticsDetailList struct {
				LogisticsDetailList []struct {
					StanderdDesc string `json:"StanderdDesc"` //物流信息
					OcurrTimeStr string `json:"OcurrTimeStr"` //发生时间
				} `json:"LogisticsDetailList"`
			} `json:"LogisticsDetailList"`
			LogisticsCompanyName string `json:"LogisticsCompanyName"` //本单物流公司名称
			LogisticsCompanyCode string `json:"logisticsCompanyCode"` //本单物流公司Code
			MailNo               string `json:"MailNo"`               //运单号
			DataProviderTitle    string `json:"DataProviderTitle"`    //数据来源说明，如:本数据由菜鸟裹裹提供
		} `json:"Data"`
	} `json:"Data"`
}

//Info 物流查询接口
func (s *deliverTm) Info(ctx context.Context, UserId, LmOrderId string) (res *DeliverInfoRes, err error) {

	method := "queryLogistics"

	request := map[string]string{
		"BizUid":           server.BizUid,
		"LmOrderId":        LmOrderId,
		"AccountType":      "ANONY",
		"ThirdPartyUserId": UserId,
	}

	result, err := post(ctx, method, request)
	_ = json.Unmarshal([]byte(result), &res)
	return
}
