package itao

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/util/gconv"
	"net/url"
	"time"
)

type upload struct {
}

var Upload = upload{}

type UploadImageReq struct {
	FileName    string `json:"fileName"`
	FileContent string `json:"fileContent"`
	ImageData   string `json:"imageData"`
}

type UploadImageRes struct {
	Code    string `json:"code"`
	Message string `json:"message"`
	FileUrl string `json:"fileUrl"`
}

func (s upload) Image(ctx context.Context, req UploadImageReq) (res *UploadImageRes, err error) {
	method := "tt.upload.image"

	req.FileContent = "base64"
	var request = g.Map{}
	request["access_token"], err = server.GetAccessToken(ctx)
	if err != nil {
		return
	}
	result, err := s.post(ctx, method, request, req)
	_ = gjson.New(result).Scan(&res)
	return
}

func (upload) post(ctx context.Context, method string, params g.Map, req UploadImageReq) (str string, err error) {
	Start := gtime.TimestampMilli()
	err = sign(method, params)
	if err != nil {
		return
	}
	Url := Host + method + "/" + server.AppKey
	Request := g.Client()
	Values := url.Values{}
	for k, v := range params {
		Values.Add(k, gconv.String(v))
	}
	Request.SetHeader("Content-Type", "application/x-www-form-urlencoded")
	resp, err := Request.Timeout(time.Second*5).Post(Url+"?"+Values.Encode(), req)

	defer func() {
		_ = resp.Close()
		paramStr := gjson.New(params).MustToJsonString()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", Url)
		if err != nil {
			g.Log().Cat(PkgName).Ctx(ctx).Infof("参数【%v】错误【%v】响应时间【%vms】", paramStr, err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Cat(PkgName).Ctx(ctx).Infof("参数【%v】响应【%v】响应时间【%vms】", paramStr, str, gtime.TimestampMilli()-Start)
		}

	}()
	str = resp.ReadAllString()
	return

}
