package itao

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type goods struct {
}

var Goods = goods{}

type GoodsListReq struct {
	Q       string `json:"q,omitempty"`    //关键词
	Sort    string `json:"sort,omitempty"` //排序参数	价格降序:sort=price:des	价格升序:sort=price:asc	综合排序:sort=popular:des	销量降序:sort=sales:des
	Price   string `json:"price,omitempty"`
	Cate    string `json:"cate,omitempty"`
	S       int    `json:"s"`
	N       int    `json:"n"`
	Feature string `json:"feature,omitempty"`
}

type GoodsListRes struct {
	ErrorMessage string `json:"error_message"`
	ErrorCode    string `json:"error_code"`
	TotalCount   int    `json:"totalCount"`
	PageIndex    int    `json:"pageIndex"`
	PageSize     int    `json:"pageSize"`
	Auctions     []struct {
		Nid                    string `json:"nid"`
		Title                  string `json:"title"`
		ReservePrice           string `json:"reservePrice"`
		ZkFinalPrice           string `json:"zkFinalPrice"`
		TejiaTotalSoldQuantity string `json:"tejiaTotalSoldQuantity"`
		PictUrl                string `json:"pictUrl"`
		LevelOneCat            string `json:"levelOneCat"`
		Category               string `json:"category"`
	} `json:"auctions"`
}

func (goods) List(ctx context.Context, req GoodsListReq) (res *GoodsListRes, err error) {
	method := "tt.item.list"

	result, err := server.Get(ctx, method, gconv.Map(req))
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsDetailReq struct {
	AppKey int    `json:"appKey"`
	ItemId string `json:"itemId"`
	SkuId  string `json:"skuId,omitempty"`
}

type GoodsDetailRes struct {
	ErrorMessage string `json:"error_message"`
	ErrorCode    string `json:"error_code"`
	Result       struct {
		DebugInfoMap struct {
			TraceId string `json:"traceId"`
		} `json:"debugInfoMap"`
		EnterNewLink string `json:"enterNewLink"`
		Item         struct {
			CategoryId   []string `json:"categoryId"`
			CategoryName []string `json:"categoryName"`
			City         string   `json:"city"`
			FastPostFee  int      `json:"fastPostFee"`
			Images       []string `json:"images"`
			ItemId       string   `json:"itemId"`
			ItemServices []struct {
				ActionTitle string `json:"actionTitle,omitempty"`
				ActionUrl   string `json:"actionUrl,omitempty"`
				Desc        string `json:"desc"`
				Title       string `json:"title"`
			} `json:"itemServices"`
			MainPic         string `json:"mainPic"`
			OrdinaryPostFee int    `json:"ordinaryPostFee"`
			Props           []struct {
				Content string `json:"content"`
				Word    string `json:"word"`
			} `json:"props"`
			Prov         string `json:"prov"`
			Receipt      bool   `json:"receipt"`
			SoldQuantity int    `json:"soldQuantity"`
			Status       int    `json:"status"`
			Title        string `json:"title"`
		} `json:"item"`
		Seller struct {
			ShopName string `json:"shopName"`
		} `json:"seller"`
		SkuBase struct {
			Props []struct {
				Name   string `json:"name"`
				Pid    string `json:"pid"`
				Values []struct {
					Image string `json:"image"`
					Name  string `json:"name"`
					Vid   string `json:"vid"`
				} `json:"values"`
			} `json:"props"`
			Skus []struct {
				PropPath string `json:"propPath"`
				SkuId    string `json:"skuId"`
			} `json:"skus"`
		} `json:"skuBase"`
		SkuCore struct {
			DefaultSkuId int64                `json:"defaultSkuId"`
			Sku2Info     map[string]GoodsItem `json:"sku2info"`
		} `json:"skuCore"`
	} `json:"result"`
}

type GoodsItem struct {
	QuantityVague  string `json:"quantityVague"`
	OriginalPrice  string `json:"originalPrice"`
	FinalPrice     string `json:"finalPrice"`
	TjbMarketPrice string `json:"tjbMarketPrice"`
	PriceMoney     string `json:"priceMoney"`
}

//Detail 详情
func (goods) Detail(ctx context.Context, GoodsID string) (res *GoodsDetailRes, err error) {
	method := "tt.item.detail.v2"
	var request = GoodsDetailReq{
		AppKey: gconv.Int(server.AppKey),
		ItemId: GoodsID,
		SkuId:  "",
	}

	result, err := server.Post(ctx, method, g.Map{
		"parameters": g.Map{
			"itemId": request,
		},
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsDescRes struct {
	ErrorMessage string         `json:"error_message"`
	ErrorCode    string         `json:"error_code"`
	Components   *GoodsDescItem `json:"components"`
}

type GoodsDescJson struct {
	ErrorMessage string `json:"error_message"`
	ErrorCode    string `json:"error_code"`
	Components   string `json:"components"`
}
type GoodsDescItem struct {
	ComponentData struct {
		DetailPic1 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_1"`
		DetailPic10 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_10"`
		DetailPic11 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_11"`
		DetailPic12 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_12"`
		DetailPic2 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_2"`
		DetailPic3 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_3"`
		DetailPic4 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_4"`
		DetailPic5 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_5"`
		DetailPic6 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_6"`
		DetailPic7 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_7"`
		DetailPic8 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_8"`
		DetailPic9 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_9"`
		DetailPicTmallPriceDesc struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
					Height string `json:"height"`
					Width  string `json:"width"`
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_tmallPriceDesc"`
	} `json:"componentData"`
	Layout []struct {
		ID  string `json:"ID"`
		Key string `json:"key"`
	} `json:"layout"`
}

//Desc 详情描述
func (goods) Desc(ctx context.Context, GoodsID string) (res *GoodsDescRes, err error) {
	method := "tt.item.desc"

	result, err := server.Get(ctx, method, g.Map{
		"itemId": GoodsID,
	})
	var data *GoodsDescJson
	err = gjson.New(result).Scan(&data)
	if err != nil {
		return
	}
	if data.ErrorCode != "" {
		err = gjson.New(result).Scan(&res)
		return
	}
	res = new(GoodsDescRes)
	_ = gjson.New(data.Components).Scan(&res.Components)
	return
}

type GoodsCategoryRes struct {
	ErrorMessage  string   `json:"error_message"`
	ErrorCode     string   `json:"error_code"`
	CateNameLists []string `json:"cateNameLists"`
	Code          string   `json:"code"`
	ItemId        string   `json:"itemId"`
	ItemName      string   `json:"itemName"`
	Message       string   `json:"message"`
}

//Category 商品类目
func (goods) Category(ctx context.Context, GoodsID string) (res *GoodsCategoryRes, err error) {
	method := "tt.item.cateInfo"

	result, err := server.Get(ctx, method, g.Map{
		"itemId": GoodsID,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
