package hdh

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/net/ghttp"
)

type OerCreateReq struct {
	Address      string         `json:"address"`      //具体地址
	AppID        string         `json:"appId"`        //
	City         string         `json:"city"`         //城市
	District     string         `json:"district"`     //地区
	IDCardNumber string         `json:"idCardNumber"` //身份证号码  非必传
	Name         string         `json:"name"`         //收件人名称
	Phone        string         `json:"phone"`        //收件人手机
	Price        float64        `json:"price"`        //商品总金额 用于校验创建订单时候 商品价格是否发生变动
	Province     string         `json:"province"`     //省份
	Desc         string         `json:"desc"`         //购买商品的备注
	SkuList      []OrderSkuList `json:"skuList"`      //购买商品的信息
	UserOrderNum string         `json:"userOrderNum"` //用户自定义订单号 非必传
}

type OrderSkuList struct {
	BuyNum      int     `json:"buyNum"`      //购买数量
	ChannelType int     `json:"channelType"` //商品渠道类型
	ItemID      int64   `json:"itemId"`      //商品id
	SkuID       int64   `json:"skuId"`       //商品skuId
	ItemCode    int64   `json:"itemCode"`    //商品编码与（itemId，skuId，channelType）必填一项，以上三个参数指定的商品优先
	Price       float64 `json:"price"`       //（当前商品sku的总价）该选项为非必填项 如果填写了 校验出商品金额发生变化 则会返回当前商品的金额发生变化的提示
}

type OerCreateRes struct {
	Code string `json:"code"`
	Data struct {
		OrderNum     string `json:"orderNum"`
		UserOrderNum string `json:"userOrderNum"`
	} `json:"data"`
	Message string `json:"message"`
	Success int    `json:"success"`
}

//订单回调信息
type OrderNotifyRes struct {
	OrderNum        string    `json:"orderNum"`        //订单号
	OrderStatus     string    `json:"orderStatus"`     //订单状态
	OrderStatusCode int       `json:"orderStatusCode"` //订单状态code 参考订单状态字典
	PkgList         []PkgList `json:"pkgList"`         //包裹信息情况
	UserOrderNum    string    `json:"userOrderNum"`    //用户订单号
}

//该包裹下商品信息
type ItemList struct {
	ChannelName string `json:"channelName"` //渠道名称
	ChannelType string `json:"channelType"` //渠道类型
	ItemID      string `json:"itemId"`      //商品id
	Number      int    `json:"number"`      //商品数量
	SkuID       string `json:"skuId"`       //商品skuId
}

//包裹信息情况
type PkgList struct {
	ExpressCompany  string     `json:"expressCompany"`  //物流公司
	ExpressNum      string     `json:"expressNum"`      //物流单号
	ItemList        []ItemList `json:"itemList"`        //该包裹下商品信息
	OrderStatus     string     `json:"orderStatus"`     //子订单状态 由于包裹存在分包情况 所有不同子订单状态可能不同
	OrderStatusCode int        `json:"orderStatusCode"` //订单状态code参考订单状态字典
	PkgNo           string     `json:"pkgNo"`           //包裹号
}

//创建订单
func OrderCreate(ctx context.Context, req *OerCreateReq) (res *OerCreateRes, err error) {

	result, err := post(ctx, "/order/create_order.do", req)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}

//订单回调
func OrderCallBack(r *ghttp.Request) (res *OrderNotifyRes, err error) {
	body, err := CheckSign(r)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(body), &res)
	return
}
