package gome

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type categoryGome struct {
}

var Category = categoryGome{}

type CategoryRes struct {
	*CommonRes
	Data []struct {
		Code       string `json:"code"`
		Level      int    `json:"level"`
		ParentCode string `json:"parentCode"`
		Name       string `json:"name"`
	} `json:"data"`
}

type CategoryPropertyRes struct {
	*CommonRes
	Data struct {
		SaleProperties []struct {
			PropertyID   int    `json:"propertyId"`
			PropertyName string `json:"propertyName"`
			PropertyType string `json:"propertyType"`
			Required     int    `json:"required"`
		} `json:"saleProperties"`
		PropertyGroups []struct {
			GroupID        int    `json:"groupId"`
			GroupName      string `json:"groupName"`
			SpecProperties []struct {
				PropertyID   int    `json:"propertyId"`
				PropertyName string `json:"propertyName"`
				PropertyType string `json:"propertyType"`
			} `json:"specProperties"`
		} `json:"propertyGroups"`
	} `json:"data"`
}

//Get 分类列表
func (categoryGome) Get(ctx context.Context, pid ...interface{}) (res *CategoryRes, err error) {
	method := "alemein.basic.get.category"

	req := g.Map{}
	if len(pid) > 0 {
		req["parentCode"] = pid[0]
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//Property 获取品类商品属性
//`categoryId` 平台三级分类代码
func (goodsGome) Property(ctx context.Context, categoryId string) (res *CategoryPropertyRes, err error) {
	method := "alamein.supplier.product.cat.get.property"

	req := g.Map{
		"categoryId": categoryId,
	}

	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
