package jingdong

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type deliveryJD struct {
}

var Delivery = deliveryJD{}

//DeliveryDetailRes 物流轨迹
type DeliveryDetailRes struct {
	*CommonRes
	Result struct {
		OrderTrack []struct {
			Content  string `json:"content"`  //操作内容明细
			MsgTime  string `json:"msgTime"`  //操作时间。日期格式为“yyyy-MM-dd hh:mm:ss”
			Operator string `json:"operator"` //操作员名称
		} `json:"orderTrack"`
		WaybillCode []struct {
			OrderID         string `json:"orderId"`         //订单号
			ParentID        string `json:"parentId"`        //父订单号。	此字段为0 未拆单
			Carrier         string `json:"carrier"`         //承运商
			DeliveryOrderID string `json:"deliveryOrderId"` //运单号
		} `json:"waybillCode"`
		JdOrderID int `json:"jdOrderId"`
	} `json:"result"`
}

// Detail 物流信息
func (*deliveryJD) Detail(ctx context.Context, OrderID string) (res *DeliveryDetailRes, err error) {
	method := "order/orderTrack"
	param := g.Map{
		"jdOrderId":   OrderID,
		"waybillCode": "1",
	}
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
