package wpc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type refundWpc struct {
}

var Refund = refundWpc{}

type RefundReasonReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	OrderSn    string `json:"orderSn"`
	ReturnId   string `json:"returnId,omitempty"`
	AreaId     string `json:"areaId,omitempty"`
}

type RefundReasonRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        interface{} `json:"result"`
}

//Reason 退货原因
func (refundWpc) Reason(ctx context.Context, req RefundReasonReq) (res *RefundReasonRes, err error) {
	method := "getReturnOrderCreate"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type RefundApplyReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	OrderSn    string `json:"orderSn"`
	SizeInfo   string `json:"sizeInfo"`
}

type RefundApplySizeInfo struct {
	SizeID   int `json:"sizeId"`
	Num      int `json:"num"`
	ReasonID int `json:"reasonId"`
}

type RefundApplyRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        interface{} `json:"result"`
}

//Apply 申请
func (refundWpc) Apply(ctx context.Context, req RefundApplyReq) (res *RefundApplyRes, err error) {
	method := "orderReturnCreate"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type RefundSubmitReq struct {
	ChannelId    string `json:"vopChannelId"`
	UserNumber   string `json:"userNumber"`
	OrderSn      string `json:"orderSn"`
	CarriersCode string `json:"carriersCode"`
	TransportNo  string `json:"transportNo"`
	Remark       string `json:"remark,omitempty"`
	ReturnId     string `json:"returnId,omitempty"`
}

type RefundSubmitRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        interface{} `json:"result"`
}

//Submit 填写回寄物流单号
func (refundWpc) Submit(ctx context.Context, req RefundSubmitReq) (res *RefundSubmitRes, err error) {
	method := "updateReturnTransportNo"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type RefundListReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	Page       string `json:"page"`
	PageSize   string `json:"pageSize"`
	OrderSn    string `json:"orderSn"`
	IsCanceled bool   `json:"isCanceled,omitempty"`
}

type RefundListRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        interface{} `json:"result"`
}

//List  列表
func (refundWpc) List(ctx context.Context, req RefundListReq) (res *RefundListRes, err error) {
	method := "multiAfterSaleList"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
