package wpc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type deliverWpc struct {
}

var Deliver = deliverWpc{}

type DeliverListReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
}

type DeliverListRes struct {
	ReturnCode string `json:"returnCode"`
	Result     []struct {
		CustNo   string `json:"custNo"`
		CustName string `json:"custName"`
		CustCode string `json:"custCode"`
	} `json:"result"`
}

//List 物流公司
func (*deliverWpc) List(ctx context.Context) (res *DeliverListRes, err error) {
	method := "getCarrierList"
	req := DeliverListReq{}
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type DeliverTrackReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	OrderSn    string `json:"orderSn"`
}

type DeliverTrackRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        interface{} `json:"result"`
}

//Track 物流轨迹
func (*deliverWpc) Track(ctx context.Context, req DeliverTrackReq) (res *DeliverTrackRes, err error) {
	method := "getOrderTrackV2"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
