package tm

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/util/gconv"
)

type refundTm struct {
}

var Refund = refundTm{}

type RefundSubmitReq struct {
	AppID        interface{}
	SubLmOrderId string //子订单号
	DisputeId    string //售后ID
	CpCode       string //物流编码
	LogisticsNo  string //物流单号
}

//Submit 提交退货物流信息接口
func (s *refundTm) Submit(ctx context.Context, req RefundSubmitReq) (res *CommonRes, err error) {
	method := "submitReturnGoodLogistics"

	request := map[string]string{
		"BizUid":           server.BizUid,
		"SubLmOrderId":     req.SubLmOrderId,
		"DisputeId":        req.DisputeId,
		"CpCode":           req.CpCode,
		"LogisticsNo":      req.LogisticsNo,
		"ThirdPartyUserId": gconv.String(req.AppID),
		"AccountType":      typeAnony,
	}

	result, err := post(ctx, method, request)
	_ = json.Unmarshal([]byte(result), &res)
	return
}

//Cancel 取消退款申请接口
func (s *refundTm) Cancel(ctx context.Context, AppID uint, subLmOrderId, disputeId string) (res *CommonRes, err error) {
	method := "cancelRefund"

	request := map[string]string{
		"BizUid":           server.BizUid,
		"SubLmOrderId":     subLmOrderId,
		"DisputeId":        disputeId,
		"ThirdPartyUserId": gconv.String(AppID),
		"AccountType":      typeAnony,
	}

	result, err := post(ctx, method, request)
	_ = json.Unmarshal([]byte(result), &res)
	return
}

type RefundBeforeReq struct {
	AppID        interface{}
	ChannelOrder string
	SubLmOrderId string
	BizClaimType string
	GoodsStatus  string
}

type RefundBeforeRes struct {
	Code                string `json:"Code"`
	Message             string `json:"Message"`
	RequestId           string `json:"RequestId"`
	InitApplyRefundData struct {
		RefundReasonList struct {
			RefundReasonList []struct {
				ReasonTextId       int64  `json:"ReasonTextId"`
				ReasonTips         string `json:"ReasonTips"`
				RefundDescRequired bool   `json:"RefundDescRequired"` //是否要求留言
				ProofRequired      bool   `json:"ProofRequired"`      //是否要求上传凭证
			} `json:"RefundReasonList"`
		} `json:"RefundReasonList"`
		MaxRefundFeeData struct {
			MaxRefundFee int64 `json:"MaxRefundFee"` //本单最大可退款金额
			MinRefundFee int64 `json:"MinRefundFee"` //本单最小可退款金额
		} `json:"MaxRefundFeeData"`
		BizClaimType int `json:"BizClaimType"` // 支持的订单退货方式，1， 标识仅退款，3，标识退货退款
	} `json:"InitApplyRefundData"`
}

// Before 前置
func (s *refundTm) Before(ctx context.Context, req RefundBeforeReq) (res *RefundBeforeRes, err error) {
	method := "initApplyRefund"

	request := map[string]string{
		"BizUid":           server.BizUid,
		"SubLmOrderId":     req.SubLmOrderId,
		"GoodsStatus":      req.GoodsStatus,
		"BizClaimType":     req.BizClaimType,
		"ThirdPartyUserId": gconv.String(req.AppID),
		"AccountType":      typeAnony,
	}

	result, err := post(ctx, method, request)
	_ = json.Unmarshal([]byte(result), &res)
	return
}

type RefundApplyReq struct {
	AppID             interface{}
	SubLmOrderId      string                //子订单号
	BizClaimType      string                //退款类型
	ApplyRefundFee    string                //申请退款金额
	ApplyRefundCount  string                //退货数量
	ApplyReasonTextId string                //退款原因ID
	LeaveMessage      string                //留言
	LeavePictureList  []*RefundApplyPicture //凭证，某些原因要求必须有凭证。
	GoodsStatus       string                //当退款类型:仅退款时，货物状态:为4未 发货。所有状态:4: 未发货, 6: 已发货, 1: 未收到货, 2: 已收到货, 3:已寄回, 5: 卖家确 认收货
}

type RefundApplyPicture struct {
	Picture string `json:"Picture"` //图片地址
	Desc    string `json:"Desc"`    //图片描述
}

type RefundApplyRes struct {
	Code                  string `json:"Code"`
	Message               string `json:"Message"`
	RequestId             string `json:"RequestId"`
	RefundApplicationData struct {
		SubLmOrderId  string `json:"SubLmOrderId"`  //当前发起逆向的子订单号
		DisputeStatus int    `json:"DisputeStatus"` //逆向的状态
		DisputeType   int    `json:"DisputeType"`   //任意退款类型
	} `json:"RefundApplicationData"`
}

//Apply 申请
func (s *refundTm) Apply(ctx context.Context, req *RefundApplyReq) (res *RefundApplyRes, err error) {
	method := "applyRefund"

	request := convert("LeavePictureList", gconv.Maps(req.LeavePictureList))
	request["SubLmOrderId"] = req.SubLmOrderId
	request["BizClaimType"] = req.BizClaimType
	request["ApplyRefundFee"] = req.ApplyRefundFee
	request["ApplyRefundCount"] = req.ApplyRefundCount
	request["ApplyReasonTextId"] = req.ApplyReasonTextId
	request["LeaveMessage"] = req.LeaveMessage
	request["GoodsStatus"] = req.GoodsStatus
	request["BizUid"] = server.BizUid
	request["AccountType"] = typeAnony
	request["ThirdPartyUserId"] = gconv.String(req.AppID)

	result, err := post(ctx, method, request)
	_ = json.Unmarshal([]byte(result), &res)
	return
}

type RefundInfoRes struct {
	Code                    string `json:"Code"`
	Message                 string `json:"Message"`
	RequestId               string `json:"RequestId"`
	RefundApplicationDetail struct {
		SubLmOrderId      string   `json:"SubLmOrderId"`      //当前发起逆向的子订单号
		RealRefundFee     int64    `json:"RealRefundFee"`     // 实际买家收到的金额
		DisputeCreateTime string   `json:"DisputeCreateTime"` //"逆向发起时间"
		DisputeDesc       string   `json:"DisputeDesc"`       //申请逆向描述
		BizClaimType      int      `json:"BizClaimType"`      // 支持的订单退货方式，1， 标识仅退款，3，标识退货退款
		ApplyDisputeDesc  string   `json:"ApplyDisputeDesc"`  //当前买家申请退款说明
		DisputeType       int      `json:"DisputeType"`       //逆向发生的类型
		SellerAgreeMsg    string   `json:"SellerAgreeMsg"`    //卖家同意退货说明,真实的退货地址会在这个字段进行返 回。
		ApplyReasonText   struct { //买家申请的逆向原因
			ReasonTextId int64  `json:"ReasonTextId"`
			ReasonTips   string `json:"ReasonTips"`
		} `json:"ApplyReasonText"`
		RefundFee                    int64  `json:"RefundFee"`                 // 退款金额(含退平台补贴的金额)
		SellerRefuseReason           string `json:"SellerRefuseReason"`        // 卖家拒绝的留言说明
		RefunderTel                  string `json:"RefunderTel"`               //退货联系方式，卖家同意退货后才显示
		LmOrderId                    string `json:"LmOrderId"`                 //对应的主订单号
		DisputeEndTime               string `json:"DisputeEndTime"`            //逆向发起时间
		RefunderName                 string `json:"RefunderName"`              //退货收货人，卖家同意退货后才显示
		RefunderZipCode              string `json:"RefunderZipCode"`           //退货地址邮编，卖家同意退货后才显示
		RefunderAddress              string `json:"RefunderAddress"`           //商家退货地址，卖家同意退货后才显示
		DisputeStatus                int    `json:"DisputeStatus"`             //// 逆向的状态
		ReturnGoodLogisticsStatus    int    `json:"ReturnGoodLogisticsStatus"` //// 退货物流状态
		SelleAgreementMessage        string `json:"SelleAgreementMessage"`
		SellerRefuseAgreementMessage string `json:"SellerRefuseAgreementMessage"` //// 卖家拒绝的留言说明
		ReturnGoodCount              int    `json:"ReturnGoodCount"`              //退货数量
		DisputeId                    int64  `json:"DisputeId"`                    //纠纷ID
	} `json:"RefundApplicationDetail"`
}

//Info 详情
func (s *refundTm) Info(ctx context.Context, AppID uint, subLmOrderId string) (res *RefundInfoRes, err error) {
	method := "queryRefundApplicationDetail"

	request := map[string]string{
		"BizUid":           server.BizUid,
		"SubLmOrderId":     subLmOrderId,
		"ThirdPartyUserId": gconv.String(AppID),
		"AccountType":      typeAnony,
	}

	result, err := post(ctx, method, request)

	_ = json.Unmarshal([]byte(result), &res)
	return
}
