package elastic

import (
	"github.com/gogf/gf/frame/g"
	"github.com/olivere/elastic/v7"
	"gitlab.jxhh.com/stbz/library.git/logs"
	"log"
	"os"
)

func connection() (search *elastic.Client, err error) {
	opts := []elastic.ClientOptionFunc{
		elastic.SetURL("http://" + g.Cfg().Get("Es.Url").(string)),
		elastic.SetSniff(false),
		elastic.SetBasicAuth(g.Cfg().Get("Es.UserName").(string), g.Cfg().Get("Es.Password").(string)),
		elastic.SetInfoLog(log.New(os.Stdout, "", log.LstdFlags)),
		elastic.SetErrorLog(log.New(os.Stderr, "ELASTIC ", log.LstdFlags)),
	}
	client, err := elastic.NewClient(opts...)
	if err != nil {
		logs.Error("Es 链接失败 error:【%v】", err)
	}
	return client, err
}
