package gome

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type stockGome struct {
}

var Stock = stockGome{}

type GetWarehouseRes struct {
	*CommonRes
	Data struct {
		*CommonPageRes
		Data []struct {
			MchWhseCode   string `json:"mchWhseCode"`
			MchWhseName   string `json:"mchWhseName"`
			IsNationWide  int    `json:"isNationWide"`
			Status        int    `json:"status"`
			LastUpateTime string `json:"lastUpateTime"`
		} `json:"data"`
	} `json:"data"`
}

type CoverAreaReq struct {
	MchWhseCode string `json:"mchWhseCode"`
	PageNo      int    `json:"pageNo"`
	PageSize    int    `json:"pageSize"`
}

type SaleAbleReq struct {
	WhseSkuList []*SaleAbleItem `json:"whseSkuList"`
}

type SaleAbleItem struct {
	MchWhseCode string `json:"mchWhseCode"`
	MchSkuId    string `json:"mchSkuId"`
}

type SaleAbleRes struct {
	*CommonRes
	Data []struct {
		MchWhseCode string `json:"mchWhseCode"`
		MchSkuId    string `json:"mchSkuId"`
		SaleableQty string `json:"saleableQty"`
	} `json:"data"`
}

//GetWarehouse 分页查询商户仓库信息
func (stockGome) GetWarehouse(ctx context.Context, req *CommonPageReq) (res *GetWarehouseRes, err error) {
	method := "alamein.stock.read.pageQueryWarehouse"

	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//CoverArea 分页查询仓市关系列表-按仓 todo
func (stockGome) CoverArea(ctx context.Context, req *CoverAreaReq) (res *CommonRes, err error) {
	method := "alamein.stock.read.queryCoverArea"

	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//ForbidCoverArea todo
func (stockGome) ForbidCoverArea(ctx context.Context, req *CoverAreaReq) (res *CommonRes, err error) {
	method := "alamein.stock.read.queryForbidCoverArea"

	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//SaleAble 查询可卖数列表
func (stockGome) SaleAble(ctx context.Context, req *SaleAbleReq) (res *SaleAbleRes, err error) {
	method := "alamein.stock.read.querySaleableQty"

	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
