package ali

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type orderAli struct {
}

var Order = orderAli{}

type CreateOrderReq struct {
	AddressParam   AddressParam
	CargoParam     []CargoParam
	OuterOrderInfo OuterOrderInfo
}

type AddressParam struct {
	FullName     string `json:"fullName"`
	Mobile       string `json:"mobile"`
	Phone        string `json:"phone"`
	PostCode     string `json:"postCode"`
	CityText     string `json:"cityText"`
	ProvinceText string `json:"provinceText"`
	AreaText     string `json:"areaText"`
	TownText     string `json:"townText"`
	Address      string `json:"address"`
}

type CargoParam struct {
	SpecId   string `json:"specId"`
	OfferId  int64  `json:"offerId"`
	Quantity int    `json:"quantity"`
}

type OuterOrderInfo struct {
	MediaOrderId string  `json:"mediaOrderId"`
	Phone        string  `json:"phone"`
	Offers       []Offer `json:"offers"`
}

type Offer struct {
	SpecId string `json:"specId"`
	Id     int64  `json:"id"`
	Num    int    `json:"num"`
	Price  int64  `json:"price"`
}

type CreateOrderRes struct {
	CommonRes
	Result struct {
		TotalSuccessAmount int64  `json:"totalSuccessAmount"` //下单成功的订单总金额，单位：分
		OrderId            string `json:"orderId"`            //下单成功后的订单id
		PostFee            int64  `json:"postFee"`            //原始运费，单位：分。注意：下单后卖家可能调整，因此该值可能不等于最终支付运费
	} `json:"result,omitempty"`
}

type OrderDetailRes struct {
	CommonRes
	Result struct {
		BaseInfo struct {
			PayTime           string  `json:"payTime"`
			Discount          int     `json:"discount"`
			AlipayTradeID     string  `json:"alipayTradeId"`
			SumProductPayment float64 `json:"sumProductPayment"`
			FlowTemplateCode  string  `json:"flowTemplateCode"`
			SellerOrder       bool    `json:"sellerOrder"`
			BuyerLoginID      string  `json:"buyerLoginId"`
			ModifyTime        string  `json:"modifyTime"`
			ID                int64   `json:"id"`
			BuyerContact      struct {
				Phone        string `json:"phone"`
				ImInPlatform string `json:"imInPlatform"`
				Name         string `json:"name"`
				CompanyName  string `json:"companyName"`
			} `json:"buyerContact"`
			SellerLoginID    string  `json:"sellerLoginId"`
			BuyerID          string  `json:"buyerID"`
			CloseOperateType string  `json:"closeOperateType"`
			TotalAmount      float64 `json:"totalAmount"`
			SellerID         string  `json:"sellerID"`
			ShippingFee      int     `json:"shippingFee"`
			Refund           int     `json:"refund"`
			Status           string  `json:"status"`
			RefundPayment    int     `json:"refundPayment"`
			SellerContact    struct {
				Phone        string `json:"phone"`
				Email        string `json:"email"`
				ImInPlatform string `json:"imInPlatform"`
				Name         string `json:"name"`
				Mobile       string `json:"mobile"`
				CompanyName  string `json:"companyName"`
			} `json:"sellerContact"`
			CouponFee    int `json:"couponFee"`
			ReceiverInfo struct {
				ToFullName     string `json:"toFullName"`
				ToDivisionCode string `json:"toDivisionCode"`
				ToMobile       string `json:"toMobile"`
				ToPhone        string `json:"toPhone"`
				ToPost         string `json:"toPost"`
				ToArea         string `json:"toArea"`
			} `json:"receiverInfo"`
			TradeType      string   `json:"tradeType"`
			IDOfStr        string   `json:"idOfStr"`
			StepPayAll     bool     `json:"stepPayAll"`
			CreateTime     string   `json:"createTime"`
			BusinessType   string   `json:"businessType"`
			OverSeaOrder   bool     `json:"overSeaOrder"`
			TradeTypeDesc  string   `json:"tradeTypeDesc"`
			PayChannelList []string `json:"payChannelList"`
			TradeTypeCode  string   `json:"tradeTypeCode"`
			PayTimeout     int      `json:"payTimeout"`
			PayTimeoutType int      `json:"payTimeoutType"`
		} `json:"baseInfo"`
		OrderBizInfo struct {
			OdsCyd      bool `json:"odsCyd"`
			CreditOrder bool `json:"creditOrder"`
		} `json:"orderBizInfo"`
		TradeTerms []struct {
			Phase         int64   `json:"phase"`
			PayWayDesc    string  `json:"payWayDesc"`
			ExpressPay    bool    `json:"expressPay"`
			PayTime       string  `json:"payTime"`
			PayStatusDesc string  `json:"payStatusDesc"`
			PayWay        string  `json:"payWay"`
			CardPay       bool    `json:"cardPay"`
			PayStatus     string  `json:"payStatus"`
			PhasAmount    float64 `json:"phasAmount"`
		} `json:"tradeTerms"`
		ProductItems []struct {
			ItemAmount         float64  `json:"itemAmount"`
			Name               string   `json:"name"`
			Price              float64  `json:"price"`
			ProductID          int64    `json:"productID"`
			ProductImgURL      []string `json:"productImgUrl"`
			ProductSnapshotURL string   `json:"productSnapshotUrl"`
			Quantity           int      `json:"quantity"`
			Refund             int      `json:"refund"`
			SkuID              int64    `json:"skuID"`
			Status             string   `json:"status"`
			SubItemID          int64    `json:"subItemID"`
			Type               string   `json:"type"`
			Unit               string   `json:"unit"`
			GuaranteesTerms    []struct {
				AssuranceInfo        string `json:"assuranceInfo"`
				AssuranceType        string `json:"assuranceType"`
				QualityAssuranceType string `json:"qualityAssuranceType"`
			} `json:"guaranteesTerms"`
			ProductCargoNumber string `json:"productCargoNumber"`
			SkuInfos           []struct {
				Name  string `json:"name"`
				Value string `json:"value"`
			} `json:"skuInfos"`
			EntryDiscount    int    `json:"entryDiscount"`
			SpecID           string `json:"specId"`
			QuantityFactor   int    `json:"quantityFactor"`
			StatusStr        string `json:"statusStr"`
			LogisticsStatus  int    `json:"logisticsStatus"`
			GmtCreate        string `json:"gmtCreate"`
			GmtModified      string `json:"gmtModified"`
			GmtPayExpireTime string `json:"gmtPayExpireTime"`
			SubItemIDString  string `json:"subItemIDString"`
		} `json:"productItems"`
		NativeLogistics struct {
			Address       string `json:"address"`
			Area          string `json:"area"`
			AreaCode      string `json:"areaCode"`
			City          string `json:"city"`
			ContactPerson string `json:"contactPerson"`
			Mobile        string `json:"mobile"`
			Province      string `json:"province"`
			Telephone     string `json:"telephone"`
			Zip           string `json:"zip"`
		} `json:"nativeLogistics"`
		GuaranteesTerms struct {
			AssuranceInfo        string `json:"assuranceInfo"`
			AssuranceType        string `json:"assuranceType"`
			QualityAssuranceType string `json:"qualityAssuranceType"`
		} `json:"guaranteesTerms"`
		OrderRateInfo struct {
			BuyerRateStatus  int `json:"buyerRateStatus"`
			SellerRateStatus int `json:"sellerRateStatus"`
		} `json:"orderRateInfo"`
		ExtAttributes []interface{} `json:"extAttributes"`
	} `json:"result"`
}

type ProductItems struct {
	Status          string  `json:"status"`          //子订单状态
	SubItemID       int64   `json:"subItemID"`       //子订单号，或商品明细条目ID
	SubItemIDString string  `json:"subItemIDString"` //子订单号，或商品明细条目ID
	SkuID           int64   `json:"skuID"`           //skuID
	ProductID       int64   `json:"productID"`       //产品ID（非在线产品为空）
	Quantity        int64   `json:"quantity"`        //以unit为单位的数量
	ItemAmount      float64 `json:"itemAmount"`      //实付金额，单位为元
	Refund          float64 `json:"refund"`          //退款金额，单位为元
	LogisticsStatus int     `json:"logisticsStatus"` //1 未发货 2 已发货 3 已收货 4 已经退货 5 部分发货 8 还未创建物流订单
	RefundIdForAs   string  `json:"refundIdForAs"`   //售后退款单号
	NativeLogistics struct {
		LogisticsItems struct {
			LogisticsCompanyId   int64   `json:"logisticsCompanyId"`   //物流公司Id
			LogisticsCompanyNo   int64   `json:"logisticsCompanyNo"`   //物流公司编号
			LogisticsCompanyName string  `json:"logisticsCompanyName"` //物流公司名称
			LogisticsBillNo      string  `json:"logisticsBillNo"`      //物流公司运单号
			Carriage             float64 `json:"carriage"`             //运费(单位为元)
			DeliveredTime        string  `json:"deliveredTime"`        //发货时间
		} `json:"logisticsItems"` //运单明细
	} `json:"nativeLogistics"` //国内物流
}

type BeforeCreateRes struct {
	CommonRes
	OrderPreviewResuslt []BeforeCreateItem `json:"orderPreviewResuslt"`
}

type BeforeCreateItem struct {
	SumPayment           int64      `json:"sumPayment"`           //订单总费用, 单位为分
	SumPaymentNoCarriage int64      `json:"sumPaymentNoCarriage"` //不包含运费的货品总费用, 单位为分.
	AdditionalFee        int64      `json:"additionalFee"`        //附加费,单位，分
	SumCarriage          int64      `json:"sumCarriage"`          //总运费信息, 单位为分.
	ResultCode           string     `json:"resultCode"`           //
	ShopPromotionList    []struct { //可用店铺级别优惠列表
		PromotionId int64 `json:"promotionId"` //优惠券ID
	} `json:"shopPromotionList"` //规格信息
	Message   string `json:"message"` //返回信息
	CargoList []struct {
		FinalUnitPrice float64 `json:"finalUnitPrice"` //最终单价
		SpecId         string  `json:"specId"`         //规格ID，offer内唯一
		OfferId        string  `json:"offerId"`        //规格ID，offer内唯一
	} `json:"cargoList"` //规格信息
}

type DeliverRes struct {
	CommonRes
	LogisticsTrace []struct {
		LogisticsBillNo      string `json:"logisticsBillNo"`      //物流单号，运单号
		LogisticsId          string `json:"logisticsId"`          //物流信息ID
		OrderId              int64  `json:"orderId"`              //订单编号
		LogisticsCompanyName string `json:"LogisticsCompanyName"` //物流公司编码
		LogisticsSteps       []struct {
			AcceptTime string `json:"acceptTime"` //物流跟踪单该步骤的时间
			Remark     string `json:"remark"`     //备注，如：“在浙江浦江县公司进行下级地点扫描，即将发往：广东深圳公司”
		} `json:"logisticsSteps"` //物流跟踪步骤
	} `json:"logisticsTrace"` //跟踪单详情
}

type GetLogisticCompanyRes struct {
	CommonRes
	Result []CompanyInfo `json:"result"` //result
}

type CompanyInfo struct {
	Id          int64  `json:"id"`
	CompanyName string `json:"companyName"` //物流公司名称
	CompanyNo   string `json:"companyNo"`   //	物流公司编号
}

//CreateOrder 下单
func (s *orderAli) CreateOrder(ctx context.Context, req *CreateOrderReq) (res *CreateOrderRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.createOrder4CybMedia"

	result, err := server.Post(ctx, method, g.Map{
		"access_token":   server.AccessToken,
		"addressParam":   gjson.New(req.AddressParam).MustToJsonString(),
		"cargoParamList": gjson.New(req.CargoParam).MustToJsonString(),
		"outerOrderInfo": gjson.New(req.OuterOrderInfo).MustToJsonString(),
	})
	_ = gjson.New(result).Scan(&res)
	return
}

//OrderDetail 订单详情
func (s *orderAli) OrderDetail(ctx context.Context, orderSn string) (res *OrderDetailRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.get.buyerView"

	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"webSite":      WebSite,
		"orderId":      orderSn,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

//Pay  支付
func (s *orderAli) Pay(ctx context.Context, orderSn string) (res *CommonRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.pay.protocolPay"

	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"orderId":      orderSn,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

//BeforeCreate 验证订单商品
func (s *orderAli) BeforeCreate(ctx context.Context, req *CreateOrderReq) (res *BeforeCreateRes, err error) {
	method := "com.alibaba.trade/alibaba.createOrder.preview4CybMedia"

	result, err := server.Post(ctx, method, g.Map{
		"access_token":   server.AccessToken,
		"addressParam":   gjson.New(req.AddressParam).MustToJsonString(),
		"cargoParamList": gjson.New(req.CargoParam).MustToJsonString(),
	})
	_ = gjson.New(result).Scan(&res)
	return
}

//Deliver 获取物流信息
func (s *orderAli) Deliver(ctx context.Context, orderSn string) (res *DeliverRes, err error) {
	method := "com.alibaba.logistics/alibaba.trade.getLogisticsTraceInfo.buyerView"

	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"orderId":      orderSn,
		"webSite":      WebSite,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

//GetLogisticCompany 物流公司
func (s *orderAli) GetLogisticCompany(ctx context.Context) (res *GetLogisticCompanyRes, err error) {
	method := "com.alibaba.logistics/alibaba.logistics.OpQueryLogisticCompanyList"
	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
