package ali

import (
	"context"
	"encoding/base64"
	"github.com/gogf/gf/container/garray"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type refundAli struct {
}

var Refund = refundAli{}

type RefundApplyReq struct {
	OrderId             string   `json:"orderId"`             //主订单
	OrderEntryIds       string   `json:"orderEntryIds"`       //子订单
	DisputeRequest      string   `json:"disputeRequest"`      //退款/退款退货。只有已收到货，才可以选择退款退货[退款:"refund"; 退款退货:"returnRefund"]
	ApplyPayment        string   `json:"applyPayment"`        //退款金额（单位：分）
	ApplyCarriage       string   `json:"applyCarriage"`       //退运费金额（单位：分）
	ApplyReasonId       string   `json:"applyReasonId"`       //退款原因id
	Description         string   `json:"description"`         //退款申请理由，2-150字
	GoodsStatus         string   `json:"goodsStatus"`         //货物状态[售中等待卖家发货:"refundWaitSellerSend"; 售中等待买家收货:"refundWaitBuyerReceive"; 售中已收货（未确认完成交易）:"refundBuyerReceived" 售后未收货:"aftersaleBuyerNotReceived"; 售后已收到货:"aftersaleBuyerReceived"]
	Vouchers            []string `json:"vouchers"`            //凭证图片URLs。1-5张，必须使用API uploadRefundVoucher返回的“图片域名/相对路径”
	OrderEntryCountList string   `json:"orderEntryCountList"` //子订单退款数量。仅在售中买家已收货（退款退货）时，可指定退货数量；默认，全部退货。
	AccessToken         string   `json:"access_token"`
}

type RefundApplyItem struct {
	Id    int64 `json:"id"`    //子订单id
	Count int64 `json:"count"` //子订单购买商品数量
}

type RefundApplyRes struct {
	Result struct {
		Code    string `json:"code"`
		Message string `json:"message"`
		Result  struct {
			RefundId string `json:"refundId"` // 创建成功，退款id
		} `json:"result"`
	} `json:"result"`
}

type RefundReasonReq struct {
	OrderId       string `json:"orderId"`       //主订单id
	OrderEntryIds string `json:"orderEntryIds"` //子订单id
	GoodsStatus   string `json:"goodsStatus"`   //货物状态 售中等待买家发货:”refundWaitSellerSend"; 售中等待买家收货:"refundWaitBuyerReceive"; 售中已收货（未确认完成交易）:"refundBuyerReceived" 售后未收货:"aftersaleBuyerNotReceived"; 售后已收到货:"aftersaleBuyerReceived"
	AccessToken   string `json:"access_token"`
}

type RefundReasonRes struct {
	Result struct {
		CommonRes
		Result struct {
			Reasons []struct {
				ID               int    `json:"id"`               //原因id
				Name             string `json:"name"`             //原因
				NeedVoucher      bool   `json:"needVoucher"`      //凭证是否必须上传
				NoRefundCarriage bool   `json:"noRefundCarriage"` //是否支持退运费
				Tip              string `json:"tip,omitempty"`    //提示
			} `json:"reasons"`
		} `json:"result"`
	} `json:"result"`
}

type RefundUploadRes struct {
	Result struct {
		CommonRes
		Result struct {
			ImageDomain      string `json:"imageDomain"`
			ImageRelativeURL string `json:"imageRelativeUrl"`
		} `json:"result"`
	} `json:"result"`
}
type RefundInfoReq struct {
	RefundId                 string `json:"refundId"`
	NeedTimeOutInfo          bool   `json:"needTimeOutInfo"`
	NeedOrderRefundOperation bool   `json:"needOrderRefundOperation"`
	AccessToken              string `json:"access_token"`
}

type RefundInfoRes struct {
	CommonRes
	Result struct {
		OpOrderRefundModelDetail struct {
			AlipayPaymentId  string `json:"alipayPaymentId"`
			ApplyCarriage    int    `json:"applyCarriage"`
			ApplyPayment     int    `json:"applyPayment"`
			ApplyReason      string `json:"applyReason"`
			ApplyReasonId    int    `json:"applyReasonId"`
			ApplySubReasonId int    `json:"applySubReasonId"`
			BuyerMemberId    string `json:"buyerMemberId"`
			BuyerSendGoods   bool   `json:"buyerSendGoods"`
			BuyerUserId      int    `json:"buyerUserId"`
			CanRefundPayment int    `json:"canRefundPayment"`
			CrmModifyRefund  bool   `json:"crmModifyRefund"`
			DisputeRequest   int    `json:"disputeRequest"`
			DisputeType      int    `json:"disputeType"`
			ExtInfo          struct {
				Enfunddetail            string `json:"enfunddetail"`
				BizCode                 string `json:"bizCode"`
				LastOrder               string `json:"lastOrder"`
				Tod                     string `json:"tod"`
				NewRefund               string `json:"newRefund"`
				BFsc                    string `json:"b_fsc"`
				AgreeReturnMsg          string `json:"agree_return_msg"`
				OpRole                  string `json:"opRole"`
				B2BBuyerMId             string `json:"b2b_buyer_mId"`
				ApplyReasonText         string `json:"apply_reason_text"`
				ApplyInitRefundFee      string `json:"apply_init_refund_fee"`
				ItemBuyAmount           string `json:"itemBuyAmount"`
				UserCredit              string `json:"userCredit"`
				SdkCode                 string `json:"sdkCode"`
				InterceptItemListResult string `json:"interceptItemListResult"`
				InterceptStatus         string `json:"interceptStatus"`
				SellerBatch             string `json:"seller_batch"`
				RestartForXiaoer        string `json:"restartForXiaoer"`
				CljZeroSecondRefund     string `json:"clj_zero_second_refund"`
				Tos                     string `json:"tos"`
				BsSync                  string `json:"bs_sync"`
				OlTf                    string `json:"ol_tf"`
				BPf                     string `json:"b_pf"`
				Sgr                     string `json:"sgr"`
				PartRefund              string `json:"part_refund"`
				Bgmtc                   string `json:"bgmtc"`
				PayMode                 string `json:"payMode"`
				AppName                 string `json:"appName"`
				SellerDoRefundNick      string `json:"sellerDoRefundNick"`
				WorkflowName            string `json:"workflowName"`
				Ttid                    string `json:"ttid"`
				SellerAudit             string `json:"seller_audit"`
				Rp3                     string `json:"rp3"`
				SellerAgreedRefundFee   string `json:"seller_agreed_refund_fee"`
				B2BBt                   string `json:"b2b_bt"`
				B2BExchange             string `json:"b2b_exchange"`
				ItemPrice               string `json:"itemPrice"`
				IsVirtual               string `json:"isVirtual"`
				EXmrf                   string `json:"EXmrf"`
				B2BSellerMId            string `json:"b2b_seller_mId"`
				BCfRsc                  string `json:"b_cf_rsc"`
			} `json:"extInfo"`
			FrozenFund           int     `json:"frozenFund"`
			GmtApply             string  `json:"gmtApply"`
			GmtCompleted         string  `json:"gmtCompleted"`
			GmtCreate            string  `json:"gmtCreate"`
			GmtModified          string  `json:"gmtModified"`
			GmtTimeOut           string  `json:"gmtTimeOut"`
			GoodsReceived        bool    `json:"goodsReceived"`
			GoodsStatus          int     `json:"goodsStatus"`
			Id                   int64   `json:"id"`
			NewRefundReturn      bool    `json:"newRefundReturn"`
			OnlyRefund           bool    `json:"onlyRefund"`
			OrderEntryIdList     []int64 `json:"orderEntryIdList"`
			OrderId              int64   `json:"orderId"`
			ProductName          string  `json:"productName"`
			RefundCarriage       int     `json:"refundCarriage"`
			RefundGoods          bool    `json:"refundGoods"`
			RefundId             string  `json:"refundId"`
			RefundPayment        int     `json:"refundPayment"`
			RejectReasonId       int     `json:"rejectReasonId"`
			RejectReason         string  `json:"rejectReason"` //	拒绝原因
			RejectTimes          int     `json:"rejectTimes"`
			SellerDelayDisburse  bool    `json:"sellerDelayDisburse"`
			SellerMemberId       string  `json:"sellerMemberId"`
			SellerMobile         string  `json:"sellerMobile"`
			SellerRealName       string  `json:"sellerRealName"`
			SellerReceiveAddress string  `json:"sellerReceiveAddress"`
			SellerUserId         int64   `json:"sellerUserId"`
			Status               string  `json:"status"`
			SupportNewSteppay    bool    `json:"supportNewSteppay"`
			TimeOutFreeze        bool    `json:"timeOutFreeze"`
			TradeTypeStr         string  `json:"tradeTypeStr"`
			RefundOperationList  []struct {
				AfterOperateStatus  string `json:"afterOperateStatus,omitempty"`
				BeforeOperateStatus string `json:"beforeOperateStatus,omitempty"`
				CloseRefundStepId   int    `json:"closeRefundStepId"`
				CrmModifyRefund     bool   `json:"crmModifyRefund"`
				Discription         string `json:"discription"`
				GmtCreate           string `json:"gmtCreate"`
				GmtModified         string `json:"gmtModified"`
				Id                  int64  `json:"id"`
				MessageStatus       int    `json:"messageStatus"`
				MsgType             int    `json:"msgType"`
				OperateRemark       string `json:"operateRemark"`
				OperateTypeInt      int    `json:"operateTypeInt"`
				OperatorLoginId     string `json:"operatorLoginId"`
				OperatorRoleId      int    `json:"operatorRoleId"`
				OperatorUserId      int64  `json:"operatorUserId"`
				RefundId            string `json:"refundId"`
			} `json:"refundOperationList"`
			BuyerLoginId  string `json:"buyerLoginId"`
			SellerLoginId string `json:"sellerLoginId"`
		} `json:"opOrderRefundModelDetail"`
	} `json:"result"`
}

type RefundSubmitReq struct {
	RefundId    string   `json:"refundId"`           //退款单号，TQ开头
	CompanyNo   string   `json:"logisticsCompanyNo"` //物流公司编码，调用alibaba.logistics.OpQueryLogisticCompanyList.offline接口查询
	ExpressSn   string   `json:"freightBill"`        //物流公司运单号，请准确填写，否则卖家有权拒绝退款
	Description string   `json:"description"`        //发货说明，内容在2-200个字之间
	Vouchers    []string `json:"vouchers"`           //凭证图片URLs，必须使用API alibaba.trade.uploadRefundVoucher返回的“图片域名/相对路径”，最多可上传 10 张图片 ；单张大小不超过1M；支持jpg、gif、jpeg、png、和bmp格式。 请上传凭证，以便以后续赔所需（不上传将无法理赔）
	AccessToken string   `json:"access_token"`
}

type RefundSubmitRes struct {
	Result struct {
		CommonRes
	} `json:"result"`
}

//Apply 创建退款退货申请
func (refundAli) Apply(ctx context.Context, req *RefundApplyReq) (res *RefundApplyRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.createRefund"

	req.AccessToken = server.AccessToken
	result, err := server.Post(ctx, method, gconv.Map(req))
	_ = gjson.New(result).Scan(&res)
	return
}

//Reason 获取退换货原因
func (*refundAli) Reason(ctx context.Context, req *RefundReasonReq) (res *RefundReasonRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.getRefundReasonList"

	req.AccessToken = server.AccessToken
	result, err := server.Post(ctx, method, gconv.Map(req))
	_ = gjson.New(result).Scan(&res)
	return
}

// Upload 上传退款退货凭证
func (*refundAli) Upload(ctx context.Context, ImgBase64 string) (res *RefundUploadRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.uploadRefundVoucher"
	dist, _ := base64.StdEncoding.DecodeString(ImgBase64)

	var imgArr = garray.New()
	for i := range dist {
		imgArr.Append(dist[i])
	}

	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"imageData":    "[" + imgArr.Join(",") + "]",
	})
	_ = gjson.New(result).Scan(&res)
	return
}

//Info 查询退款单详情-根据退款单ID
func (*refundAli) Info(ctx context.Context, refundId string) (res *RefundInfoRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.refund.OpQueryOrderRefund"

	var req = &RefundInfoReq{
		RefundId:                 refundId,
		NeedOrderRefundOperation: true,
		AccessToken:              server.AccessToken,
	}
	result, err := server.Post(ctx, method, gconv.Map(req))
	_ = gjson.New(result).Scan(&res)
	return
}

//Submit 提交退款货信息
func (*refundAli) Submit(ctx context.Context, req *RefundSubmitReq) (res *RefundSubmitRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.refund.returnGoods"

	result, err := server.Post(ctx, method, gconv.Map(req))
	_ = gjson.New(result).Scan(&res)
	return
}
