
## stbz/library

胜天半子内部调用库
## 地址

    https://gitlab.jxhh.com/stbz/library

## 限制

    golang版本 >= 1.16

## 使用方法

### 生产者  在boot/boot.go
```golang  
package boot

import (
	"github.com/gogf/gf/frame/g"
	"gitlab.jxhh.com/stbz/library.git/notify"
)

func init() {
    //加载nsq配置文件
	addr := g.Cfg().GetString("messagequeue.link")
	notify.New(&notify.NsqConfig{Addr: addr})
}
```
### 生产者  服务中调用
```golang  
package test

import (
	"github.com/gogf/gf/frame/g"
	"gitlab.jxhh.com/stbz/library.git/notify"
)

func Servie() {
    //推送内容
	msgData := &define.CommonMessage{Source: upstream.Cloud, MsgSendTime: gtime.Timestamp()}
	msgJsonData,err := json.Marshal(msgData)
	if logs.CheckErr(err, "Marshal"){
		return
	}
	//调用方法
	err = notify.NsqProducers.Publish(pushTopic,string(msgJsonData))
}
```
### 消费者  在脚本文件 script/script.go消费
```golang  
package script

import (
	"github.com/gogf/gf/net/ghttp"
	logs "gitlab.jxhh.com/stbz/library.git/notify"

)
        
func Run() {
    //加载nsq配置文件
	addr := g.Cfg().GetString("messagequeue.link")
    // 初始化要消费的topic channel和消费的结构体
	notify.InitConsumer(&notify.NsqConfig{Addr: addr, Channel: notify.MsgCloudTopic, Topic: notify.MsgCloudTopic, Handler: &message.CloudMessage})
    // 多个消费调用的示例
	notify.InitConsumer(&notify.NsqConfig{Addr: addr, Channel: notify.NotifyTopic, Topic: notify.NotifyTopic, Handler: &handle.Message})

	select {}
}
```    



