package schl

type CommonRes struct {
	Code int    `json:"code"`
	Msg  string `json:"msg"`
}

type PubilcParams struct {
	AppID     string `json:"appId"`
	Nonce     string `json:"nonce"`
	Timestamp string `json:"timestamp"`
	Signature string `json:"signature"`
}

type CategoryRes struct {
	CommonRes
	Result []CategoryItem `json:"result"`
}
type CategoryItem struct {
	Id    int    `json:"id"`
	Img   string `json:"img"`
	Name  string `json:"name"`
	SupId int    `json:"supId"`
}

type ListGoodsRes struct {
	CommonRes
	Result []ListGoodsItem `json:"result"`
}

type ListGoodsItem struct {
	Code                 string   `json:"code"`
	Name                 string   `json:"name"`
	ItemMainImg          string   `json:"itemMainImg"`
	Imgs                 []string `json:"imgs"`
	DetailImgs           []string `json:"detailImgs"`
	GoodsVideo           string   `json:"goodsVideo"`
	ShareImg             string   `json:"shareImg"`
	ShareVideo           string   `json:"shareVideo"`
	MarketPrice          float64  `json:"marketPrice"`
	MarketPriceTagImg    string   `json:"marketPriceTagImg"`
	NormalPrice          float64  `json:"normalPrice"`
	Vip1Price            float64  `json:"vip1Price"`
	Vip2Price            float64  `json:"vip2Price"`
	CurrVipPrice         float64  `json:"currVipPrice"`
	MinBuyNum            int      `json:"minBuyNum"`
	PlusStep             int      `json:"plusStep"`
	Unit                 string   `json:"unit"`
	Weight               float64  `json:"weight"`
	Volume               float64  `json:"volume"`
	Stock                int      `json:"stock"`
	State                int      `json:"state"`
	ForbidBuyArea        string   `json:"forbidBuyArea"`
	SupplierFreightPayer int      `json:"supplierFreightPayer"`
	CategoryGRList       []struct {
		C1 int `json:"c1"`
		C2 int `json:"c2"`
	} `json:"categoryGRList"`
}

type ListGoodsByCodesReq struct {
	CodeList []string `json:"codeList"` //["ZGRSH12","ZGYSH11","ZGJRJ10","ZGGTJ09","CWSKYTJ15","CWDYLG14"]
}

type OrderFreightPreviewReq struct {
	Province        string `json:"province"`
	City            string `json:"city"`
	District        string `json:"district"`
	AddressDetail   string `json:"addressDetail"`
	GoodsParamsList string `json:"goodsParamsList"` //[{\"code\":\"goodsCode1\",\"goodsNum\":1}]
}

type OrderFreightPreviewRes struct {
	CommonRes
	Result OrderFreightPreviewItem `json:"result"`
}

type OrderFreightPreviewItem struct {
	ExpName string  `json:"expName"` //运费总额
	Freight float64 `json:"freight"` //快递编码
	ExpCode string  `json:"expCode"` //快递名称
}

type CreateOrderReq struct {
	PlatformOrderNo string `json:"platformOrderNo"` //商户单号，若创建多商品订单建议不传该参
	CustName        string `json:"custName"`        //收货人
	CustMobile      string `json:"custMobile"`      //收货人联系方式
	Province        string `json:"province"`        //省
	City            string `json:"city"`            //市
	District        string `json:"district"`        //区
	AddressDetail   string `json:"addressDetail"`
	GoodsParamsList string `json:"goodsParamsList"` //[{\"code\":\"goodsCode1\",\"goodsNum\":1}]code需创建订单的商品编码 goodsNum 数量
}

type CreateOrderRes struct {
	CommonRes
	Result CreateOrderItem `json:"result"`
}

type CreateOrderItem struct {
	UnionId          string `json:"unionId"`          //平台订单编号,用于后续操作平台订单
	PayMoney         string `json:"payMoney"`         //支付总额
	GoodsMoneyAmount string `json:"goodsMoneyAmount"` //商品总额
	ExpFeeAmount     string `json:"expFeeAmount"`     //运费总额
	ExpCode          string `json:"expCode"`          //快递编码
	ExpName          string `json:"expName"`          //快递名称
}

type SyncOrderExpNoReq struct {
	UnionIdList string `json:"unionIdList"` //平台订单编号数组，需转成String传入
}

type SyncOrderExpNoRes struct {
	CommonRes
	Result []struct {
		UnionId string   `json:"unionId"` //平台订单编号
		ExpNo   []string `json:"expNo"`   //快递/物流单号
	} `json:"result"`
}

type QueryExpTrackReq struct {
	UnionId    string `json:"unionId"`    //平台订单编号,用于后续操作平台订单
	ExpNos     string `json:"expNo"`      //订单对应的快递单号数组
	BusinessId string `json:"businessId"` //业务订单编号(平台中所查看到的订单编号)
}

type QueryExpTrackRes struct {
	CommonRes
	Result QueryExpTrackItem `json:"result"`
}

type QueryExpTrackItem struct {
	ExpInfo string `json:"expInfo"` //json
}

type ExpInfoItem struct {
	Number string `json:"number"`
	Type   string `json:"type"`
	List   []struct {
		Time   string `json:"time"`
		Status string `json:"status"`
	} `json:"list"`
	Deliverystatus string `json:"deliverystatus"`
	Issign         string `json:"issign"`
	ExpName        string `json:"expName"`
	ExpSite        string `json:"expSite"`
	ExpPhone       string `json:"expPhone"`
	Logo           string `json:"logo"`
	Courier        string `json:"courier"`
	CourierPhone   string `json:"courierPhone"`
	UpdateTime     string `json:"updateTime"`
	TakeTime       string `json:"takeTime"`
}
