package schl

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type GoodsEventRes struct {
	CommonRes
	Result []struct {
		EventKey string `json:"eventKey"`
		//GOODS_PRICE:规格价格变动
		//GOODS_UP_STATE:商品上架
		//GOODS_DOWN_STATE:商品下架
		//GOODS_UPDATE_STOCK:规格库存变动
		//GOODS_ADD_ITEM:商品添加规格
		//GOODS_REMOVE_ITEM:商品移除规格
		EventDesc      string `json:"eventDesc"`
		ChangesContent []struct {
			Code    string `json:"code,omitempty"`
			Price   string `json:"price,omitempty"`
			Id      string `json:"id,omitempty"`
			GoodsId string `json:"goodsId,omitempty"`
			State   string `json:"state,omitempty"`
		} `json:"changesContent"`
	} `json:"result"`
}

func (s *Config) GoodsEvent(ctx context.Context) (res *GoodsEventRes, err error) {

	result, err := s.Post(ctx, "/open/xdxt/api/v2/goods/listGoodsChangeEvent", g.Map{})
	if err != nil {
		return
	}

	err = gjson.New(result).Scan(&res)
	return
}
