package ikc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type goodsIkc struct {
}

//Goods 商品
var Goods = goodsIkc{}

type GoodsListReq struct {
	LiveId      string `json:"liveId"`
	PageNo      int    `json:"pageNo"`
	PageSize    int    `json:"pageSize"`
	SortedType  int    `json:"sortedType"`  //顺序 1：正序，2倒序 默认2
	SortedModel int    `json:"sortedModel"` //排序模式 1:默认（售罄沉底、运营指定顺序、上架次数、播号） 3:销量（累计30天） 6:上新次数 7:销售价 9:折扣 10:开始时间 默认排序模式只有倒序
}

type goodsListRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          struct {
		Total       int `json:"total"`
		ProductList []struct {
			ActivityId        string        `json:"activityId"`
			ProductId         string        `json:"productId"`
			Status            int           `json:"status"`
			Brand             string        `json:"brand"`
			BrandUrl          string        `json:"brandUrl"`
			TagPrice          float64       `json:"tagPrice"`
			CategoryCode      string        `json:"categoryCode"`
			Category          string        `json:"category"`
			Picture           []string      `json:"picture"`
			BrandSizeUrl      string        `json:"brandSizeUrl"`
			Price             float64       `json:"price"`
			Name              string        `json:"name"`
			SettlementPrice   float64       `json:"settlementPrice"`
			Profit            float64       `json:"profit"`
			Description       string        `json:"description"`
			Pinlei1           string        `json:"pinlei1"`
			Pinlei1Name       string        `json:"pinlei1name"`
			Pinlei2           string        `json:"pinlei2"`
			Pinlei2Name       string        `json:"pinlei2name"`
			VideoUrl          string        `json:"videoUrl"`
			VideoCoverUrl     string        `json:"videoCoverUrl"`
			StyleNo           string        `json:"styleNo"`
			MerStyleNo        string        `json:"merStyleNo"`
			ProductNum        string        `json:"productNum"`
			SupportExchange   int           `json:"supportExchange"`
			Color             string        `json:"color"`
			BaseProperties    []interface{} `json:"baseProperties"`
			MeasureProperties []interface{} `json:"measureProperties"`
			ProductMateria    []interface{} `json:"productMateria"`
			SkuList           []struct {
				SkuId         string `json:"skuId"`
				AttributeList []struct {
					AttributeName  string `json:"attributeName"`
					AttributeValue string `json:"attributeValue"`
				} `json:"attributeList"`
				LeftStoreNum int `json:"leftStoreNum"`
			} `json:"skuList"`
			SkusAttributeList []struct {
				AttributeName  string `json:"attributeName"`
				AttributeValue string `json:"attributeValue"`
			} `json:"skusAttributeList"`
			ProfitAdditional struct {
				MarketId         string  `json:"marketId"`
				ProfitAdditional float64 `json:"profitAdditional"`
			} `json:"profitAdditional"`
			PromoTags []struct {
				Code string `json:"code"`
				Name string `json:"name"`
				Type int    `json:"type"`
			} `json:"promoTags"`
			RefundInsurance       bool `json:"refundInsurance"`
			IsExchangeRefundGoods int  `json:"isExchangeRefundGoods"`
		} `json:"productList"`
	} `json:"data"`
}

//List 列表
func (*goodsIkc) List(ctx context.Context, req GoodsListReq) (res *goodsListRes, err error) {
	method := "product/list"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsDetailRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          struct {
		Product struct {
			ActivityId      string   `json:"activityId"`
			ProductId       string   `json:"productId"`
			Status          int      `json:"status"`
			Brand           string   `json:"brand"`
			BrandUrl        string   `json:"brandUrl"`
			TagPrice        float64  `json:"tagPrice"`
			CategoryCode    string   `json:"categoryCode"`
			Category        string   `json:"category"`
			Picture         []string `json:"picture"`
			BrandSizeUrl    string   `json:"brandSizeUrl"`
			Price           float64  `json:"price"`
			Name            string   `json:"name"`
			SettlementPrice float64  `json:"settlementPrice"`
			Profit          float64  `json:"profit"`
			Description     string   `json:"description"`
			Pinlei1         string   `json:"pinlei1"`
			Pinlei1Name     string   `json:"pinlei1name"`
			Pinlei2         string   `json:"pinlei2"`
			Pinlei2Name     string   `json:"pinlei2name"`
			VideoUrl        string   `json:"videoUrl"`
			VideoCoverUrl   string   `json:"videoCoverUrl"`
			StyleNo         string   `json:"styleNo"`
			MerStyleNo      string   `json:"merStyleNo"`
			ProductNum      string   `json:"productNum"`
			SupportExchange int      `json:"supportExchange"`
			Color           string   `json:"color"`
			BaseProperties  []struct {
				AttributeName  string `json:"attributeName"`
				AttributeValue string `json:"attributeValue"`
			} `json:"baseProperties"`
			MeasureProperties []struct {
				AttributeName  string `json:"attributeName"`
				AttributeValue string `json:"attributeValue"`
			} `json:"measureProperties"`
			ProductMateria []interface{} `json:"productMateria"`
			SkuList        []struct {
				SkuId         string `json:"skuId"`
				AttributeList []struct {
					AttributeName  string `json:"attributeName"`
					AttributeValue string `json:"attributeValue"`
				} `json:"attributeList"`
				LeftStoreNum int `json:"leftStoreNum"`
			} `json:"skuList"`
			SkusAttributeList []struct {
				AttributeName  string `json:"attributeName"`
				AttributeValue string `json:"attributeValue"`
			} `json:"skusAttributeList"`
			Weight           string `json:"weight"`
			Volume           string `json:"volume"`
			ProfitAdditional struct {
				MarketId         string  `json:"marketId"`
				ProfitAdditional float64 `json:"profitAdditional"`
			} `json:"profitAdditional"`
			PromoTags []struct {
				Code string `json:"code"`
				Name string `json:"name"`
				Type int    `json:"type"`
			} `json:"promoTags"`
			RefundInsurance       bool `json:"refundInsurance"`
			IsExchangeRefundGoods int  `json:"isExchangeRefundGoods"`
		} `json:"product"`
	} `json:"data"`
}

//Detail 详情
func (*goodsIkc) Detail(ctx context.Context, GoodsID, activeId string) (res *GoodsDetailRes, err error) {
	method := "product/detail"
	result, err := post(ctx, method, g.Map{
		"productId": GoodsID,
		"activeId":  activeId,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsStockReq struct {
	LiveId string   `json:"liveId"`
	SkuIds []string `json:"skuIds"`
}
type GoodsStockRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          struct {
		LiveId        string `json:"liveId"`
		InventoryList []struct {
			SkuId        string `json:"skuId"`
			CurrentStock string `json:"currentStock"`
		} `json:"inventoryList"`
	} `json:"data"`
}

//Stock 库存
func (*goodsIkc) Stock(ctx context.Context, req GoodsStockReq) (res *GoodsStockRes, err error) {
	method := "inventory/query"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsBatchReq struct {
	Params []GoodsBatchItem `json:"params"`
}

type GoodsBatchItem struct {
	GoodsID    string `json:"productId"`
	ActivityId string `json:"activityId"`
}

type GoodsBatchRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          struct {
		Products []struct {
			ActivityId      string  `json:"activityId"`
			ProductId       string  `json:"productId"`
			Status          int     `json:"status"`
			Brand           string  `json:"brand"`
			BrandUrl        string  `json:"brandUrl"`
			TagPrice        float64 `json:"tagPrice"`
			CategoryCode    string  `json:"categoryCode"`
			Category        string  `json:"category"`
			Price           float64 `json:"price"`
			Name            string  `json:"name"`
			SettlementPrice float64 `json:"settlementPrice"`
			Profit          float64 `json:"profit"`
			Description     string  `json:"description"`
			Pinlei1         string  `json:"pinlei1"`
			Pinlei1Name     string  `json:"pinlei1name"`
			Pinlei2         string  `json:"pinlei2"`
			Pinlei2Name     string  `json:"pinlei2name"`
			StyleNo         string  `json:"styleNo"`
			MerStyleNo      string  `json:"merStyleNo"`
			ProductNum      string  `json:"productNum"`
			SupportExchange int     `json:"supportExchange"`
			Color           string  `json:"color"`
			SkuList         []struct {
				SkuId         string `json:"skuId"`
				AttributeList []struct {
					AttributeName  string `json:"attributeName"`
					AttributeValue string `json:"attributeValue"`
				} `json:"attributeList"`
				LeftStoreNum int `json:"leftStoreNum"`
			} `json:"skuList"`
			SkusAttributeList []struct {
				AttributeName  string `json:"attributeName"`
				AttributeValue string `json:"attributeValue"`
			} `json:"skusAttributeList"`
			ProfitAdditional struct {
				MarketId         string  `json:"marketId"`
				ProfitAdditional float64 `json:"profitAdditional"`
			} `json:"profitAdditional"`
			PromoTags []struct {
				Code string `json:"code"`
				Name string `json:"name"`
				Type int    `json:"type"`
			} `json:"promoTags"`
			RefundInsurance       bool `json:"refundInsurance"`
			IsExchangeRefundGoods int  `json:"isExchangeRefundGoods"`
		} `json:"products"`
	} `json:"data"`
}

//Batch 批量查询
func (*goodsIkc) Batch(ctx context.Context, req GoodsBatchReq) (res *GoodsBatchRes, err error) {
	method := "product/listByIds"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsFreightReq struct {
	Province string             `json:"province"`
	City     string             `json:"city"`
	Area     string             `json:"area"`
	List     []GoodsFreightItem `json:"productList"`
}

type GoodsFreightItem struct {
	LiveId    string `json:"liveId"`    //活动 ID
	ProductId string `json:"productId"` //商品 ID
	Count     string `json:"count"`     //商品数量
}

type GoodsFreightRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          struct {
		ProductList []struct {
			LiveId       string `json:"liveId"`
			ProductId    string `json:"productId"`
			AllowDeliver int    `json:"allowDeliver"`
			DenyReason   string `json:"denyReason,omitempty"`
		} `json:"productList"`
		FreightList []struct {
			Freight     float64 `json:"freight"`
			ProductList []struct {
				LiveId    string `json:"liveId"`
				ProductId string `json:"productId"`
				Count     int    `json:"count"`
			} `json:"productList"`
		} `json:"freightList"`
	} `json:"data"`
}

//Freight 查询运费
func (*goodsIkc) Freight(ctx context.Context, req GoodsFreightReq) (res *GoodsFreightRes, err error) {
	method := "freight/query"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}
