package suning

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type AllAddressServiceReq struct {
	SnRequest struct {
		SnBody struct {
			QueryAlladdressservice struct {
			} `json:"queryAlladdressservice"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type AllAddressServiceRes struct {
	SnResponseContent struct {
		SnBody struct {
			QueryAlladdressservice struct {
				AddressList []struct {
					SecondPid string `json:"secondPid"`
					SnId      string `json:"snId"`
					Level     string `json:"level"`
					Name      string `json:"name"`
					Pid       string `json:"pid"`
					Id        string `json:"id"`
				} `json:"addressList"`
			} `json:"queryAlladdressservice"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

//获取全部地址
func AllAddressService(ctx context.Context) (res AllAddressServiceRes, err error) {
	params := AllAddressServiceReq{}
	result, err := post(ctx, "suning.sngoods.alladdressservice.query", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
