package dwd

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

//类目
type categoryDwd struct {
}

var Category = &categoryDwd{}

type CategoryListReq struct {
	Pid   string `json:"pid"`
	Depth string `json:"depth"`
}

type CategoryListRes struct {
	Errno     int               `json:"errno"`
	Errmsg    string            `json:"errmsg"`
	Data      *CategoryListData `json:"data"`
	RequestId string            `json:"request_id"`
	Timestamp int               `json:"timestamp"`
	Signature string            `json:"signature"`
}

type CategoryListData struct {
	List []struct {
		Id           int    `json:"id"`
		Pid          int    `json:"pid"`
		Depth        int    `json:"depth"`
		CategoryName string `json:"categoryName"`
	} `json:"list"`
}

func (*categoryDwd) List(ctx context.Context, req CategoryListReq) (res *CategoryListRes, err error) {
	var method = "common.categoryBackList"
	result, err := post(ctx, method, req)
	if err != nil {
		return
	}
	res = &CategoryListRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}
