package wpc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type commonWpc struct {
}

var Common = commonWpc{}

type CommonUploadReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	Image      string `json:"imageBase64String"`
	FileName   string `json:"fileName,omitempty"`
}

type CommonUploadRes struct {
	ReturnCode    string `json:"returnCode"`
	ReturnMessage string `json:"returnMessage"`
	Result        struct {
		Url string
	} `json:"result"`
}

//Upload 上传图片
func (*commonWpc) Upload(ctx context.Context, req CommonUploadReq) (res *CommonUploadRes, err error) {
	method := "commonUploadImg4Ugc"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
