package itao

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type addressItao struct {
}

var Address = addressItao{}

type AddressDivisionReq struct {
	Province string `json:"prov,omitempty"`
	City     string `json:"city,omitempty"`
	Area     string `json:"distinct,omitempty"`
	Town     string `json:"town,omitempty"`
	Page     int    `json:"pageIndex"`
	Size     int    `json:"pageSize"`
}

type AddressDivisionRes struct {
	Result struct {
		Result struct {
			Divisions []struct {
				DivisionId    int    `json:"divisionId"`
				DivisionLeaf  bool   `json:"divisionLeaf"`
				DivisionToken string `json:"divisionToken"`
				Level         int    `json:"level"`
				Names         struct {
					EN string `json:"EN"`
					CN string `json:"CN"`
				} `json:"names"`
			} `json:"divisions"`
			PageIndex   int    `json:"pageIndex"`
			PageSize    int    `json:"pageSize"`
			ParentToken string `json:"parentToken"`
			TotalCount  int    `json:"totalCount"`
			TotalPage   int    `json:"totalPage"`
		} `json:"result"`
		Success bool   `json:"success"`
		ErrMsg  string `json:"errMsg"`
		ErrCode string `json:"errCode"`
	} `json:"result"`
}

//Division 行政区划
func (s addressItao) Division(ctx context.Context, req AddressDivisionReq) (res *AddressDivisionRes, err error) {
	method := "tt.order.queryDivision"

	result, err := server.Post(ctx, method, g.Map{
		"param": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type AddressParseReq struct {
	Province string `json:"prov"`
	City     string `json:"city"`
	Detail   string `json:"addressDetail"`
}

type AddressParseRes struct {
	Result struct {
		City       string `json:"city"`
		CityId     int    `json:"cityId"`
		District   string `json:"district"`
		DistrictId int    `json:"districtId"`
		Prov       string `json:"prov"`
		ProvId     int    `json:"provId"`
		Town       string `json:"town"`
		TownId     int    `json:"townId"`
	} `json:"result"`
	Success bool `json:"success"`
}

//Parse 地址解析
// 省、市必传
func (s addressItao) Parse(ctx context.Context, req AddressParseReq) (res *AddressParseRes, err error) {
	method := "tt.address.validate"

	result, err := server.Post(ctx, method, g.Map{
		"param": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
